#!/usr/bin/env python

# Copyright (c) 2002-2009 Userful Corporation. All rights reserved.
# http://www.userful.com/

# submission.py (replaced previous incarnation July 2009)

"""
a dialog to take the user's information to include in a debug submission
"""

import gtk 
import os
import time
import sys
import getopt

import gettext

gettext.bindtextdomain('userful-control-panel')
gettext.textdomain('userful-control-panel')

_ = gettext.gettext

sys.path.append('/usr/share/umx-utils')


def extract_values(widget_dict):
    value_dict = {}

    try:
        value_dict["email"] = widget_dict["email"].get_text()
    except KeyError:
        value_dict["email"]

    try:
        value_dict["customer"] = widget_dict["customer"].get_text()
    except KeyError:
        value_dict["customer"] = ""

    try:
        value_dict["ticket"] = widget_dict["ticket"].get_text()
    except KeyError:
        value_dict["ticket"] = ""

    try:
        desc_buffer = widget_dict["description"].get_buffer()
        value_dict["description"] = desc_buffer.get_text(desc_buffer.get_start_iter(), desc_buffer.get_end_iter())
    except KeyError:
        value_dict["description"]

    try:
        value_dict["file_name"] = widget_dict["file_name"]
    except KeyError:
        pass

    return value_dict

def verify_values(value_dict):
    email = value_dict["email"]

    # this causes too many false Negatives
    
    #import re
    #p = re.compile("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3\})(\\]?)$")
    #if p.match(email):
    #    return True
    #return False

    at_index = email.find("@")

    if at_index < 1:
        return False

    dot_index = email.rfind(".")

    if dot_index < at_index or dot_index > (len(email) - 3):
        return False

    return True

def write_values(value_dict):
    file_name = "/dev/stdout"
    try:
        file_name = value_dict["file_name"] 
    except KeyError:
        print "no file name provided"
        pass

    out_file = file(file_name, "w")

    if out_file is None:
        return False
    
    email = value_dict["email"]
    customer = value_dict["customer"]
    ticket = value_dict["ticket"]
    desc = value_dict["description"]

    out_file.write("EMAIL=\"" + str(email) + "\"\n")
    out_file.write("CUSTOMER=\"" + str(customer) + "\"\n")
    out_file.write("TICKET=\"" + str(ticket) + "\"\n")
    out_file.write("DETAILS=\"\"\"" + str(desc) + "\"\"\"\n")
    out_file.close()
    return True

def response_callback(dialog, response_id, data=None):

    if response_id == gtk.RESPONSE_REJECT:
        # pressed the cancel buton
        gtk.main_quit()
        sys.exit(1)
        return

    if response_id == gtk.RESPONSE_DELETE_EVENT:
        # the dialog was closed using the 'X'
        gtk.main_quit()
        return

    if response_id == gtk.RESPONSE_OK:
        # 'ok' button was pressed (The OK button is currently only on the error dialog)
        dialog.destroy()
        print "got ok event"
        return

    if response_id == 1:
        # submit button was pressed
        print "got submit"
        value_dict =  extract_values(data)

        if verify_values(value_dict):
            write_values(value_dict)
            gtk.main_quit()
        else:
            display_error(dialog, _("Email address format not valid."))
        
    return

def display_error(parent, text):
    dialog = gtk.Dialog(_("Submit Debug Information"),
                        parent,
                        gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                        (gtk.STOCK_OK, gtk.RESPONSE_OK))

    # not available on SLED 11
    #content_area_vbox = dialog.get_content_area()

    hbox = gtk.HBox()
    hbox.set_spacing(5)
    hbox.set_border_width(5)
    
    #content_area_vbox.add(hbox)
    content_area_vbox = dialog.get_child()
    content_area_vbox.pack_start(hbox)


    image = gtk.Image()
    image.set_from_stock(gtk.STOCK_DIALOG_ERROR, gtk.ICON_SIZE_DIALOG)
    hbox.add(image)

    dialog_text = gtk.Label()
    dialog_text.set_text(text)
    dialog_text.set_line_wrap(True)
    hbox.add(dialog_text)

    dialog.connect("response", response_callback)

    dialog.show_all()

    dialog.run()

    return

def create_dialog(parent, response_callback_function, file_name=None):

    main_dialog = gtk.Dialog(_("Submit Debug Information"),
                        parent,
                        gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                        (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))

    #main_dialog.set_has_separator(False)

    # not available on SLED 11
    #content_area_vbox = main_dialog.get_content_area()

    main_vbox = gtk.VBox()
    main_vbox.set_spacing(5)
    main_vbox.set_border_width(5)

    #content_area_vbox.add(main_vbox)
    content_area_vbox = main_dialog.get_child()
    content_area_vbox.pack_start(main_vbox)

    top_hbox = gtk.HBox()
    top_hbox.set_spacing(5)
    top_hbox.set_border_width(5)
    main_vbox.add(top_hbox)

    main_image = gtk.Image()
    main_image.set_from_stock(gtk.STOCK_DIALOG_WARNING, gtk.ICON_SIZE_DIALOG)
    top_hbox.add(main_image)

    main_text = gtk.Label()
    main_text.set_text(_("A system information report that includes log files will be created that will be submitted along with this form. We will treat all gathered information as confidential. Please include a description of the problem in the field below and your email address if you want a response."))
    main_text.set_line_wrap(True)
    top_hbox.add(main_text)

    info_frame = gtk.Frame()
    info_frame.set_shadow_type(gtk.SHADOW_NONE)

    info_frame_lable = gtk.Label()
    info_frame_lable.set_use_markup(True)
    info_frame_lable.set_markup(_("<b>Optional Information</b>"))
    info_frame.set_label_widget(info_frame_lable)

    main_vbox.add(info_frame)

    info_frame_alignment = gtk.Alignment(xalign=0.5, yalign=0.5, xscale=1.0, yscale=1.0)
    info_frame_alignment.set_padding(0, 0, 10, 0)
    info_frame.add(info_frame_alignment)

    info_frame_vbox = gtk.VBox(spacing=5)
    info_frame_vbox.set_border_width(10)
    info_frame_alignment.add(info_frame_vbox)

    email_address_label = gtk.Label()
    email_address_label.set_text(_("Email Address:"))
    email_address_label.set_alignment(0, 0.5)
    info_frame_vbox.add(email_address_label)

    email_address_text_entry = gtk.Entry()
    info_frame_vbox.add(email_address_text_entry)

    customer_name_label = gtk.Label()
    customer_name_label.set_text(_("Customer name:"))
    customer_name_label.set_alignment(0, 0.5)
    info_frame_vbox.add(customer_name_label)
    customer_name_text_entry = gtk.Entry()
    info_frame_vbox.add(customer_name_text_entry)

    ticket_number_label = gtk.Label()
    ticket_number_label.set_text(_("Ticket Number (if applicable):"))
    ticket_number_label.set_alignment(0, 0.5)
    info_frame_vbox.add( ticket_number_label)
    ticket_number_text_entry = gtk.Entry()
    info_frame_vbox.add(ticket_number_text_entry)

    description_label = gtk.Label()
    description_label.set_text(_("Description of problem:"))
    description_label.set_alignment(0, 0.5)
    info_frame_vbox.add(description_label)

    description_scroll_container = gtk.ScrolledWindow()
    description_scroll_container.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    description_scroll_container.set_shadow_type(gtk.SHADOW_IN)
    info_frame_vbox.add(description_scroll_container)

    description_text_area = gtk.TextView()
    description_text_area.set_wrap_mode(gtk.WRAP_WORD)
    description_scroll_container.add(description_text_area)

    # create a disctionary of widgets
    data = { "email" : email_address_text_entry,
             "customer": customer_name_text_entry, 
             "ticket" : ticket_number_text_entry,
             "description": description_text_area,
             "file_name": file_name }

    main_dialog.connect("response", response_callback_function, data)
    main_dialog.add_button("Submit", 1)
    main_dialog.set_default_response(1)

    main_dialog.show_all()
    return;

def usage(msg=''):
    print >> sys.stderr, __doc__
    if msg:
        print >> sys.stderr, msg

def main():

    try:
        optlist, args = getopt.getopt(sys.argv[1:], "hf:", ["help", "file="])
    except getopt.GetoptError:
        # print help information and exit:
        usage("Error in parsing arguments")
        sys.exit(2)

    file_name = "/dev/stdout"

    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o in ("-f", "--file"):
            file_name = a

    create_dialog(None, response_callback, file_name=file_name)

    gtk.main()

if __name__ == "__main__":
    main()

