#!/bin/bash
#
#   userful-reset-daemon.sh
# 
# Description:  This problem checks system daemons and starts them if they are not running.
#               Currently it checks "dbus" and "hal" daemon and is only applied to Userful Desktop.
#

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

##
## This program should be run as root
if [ ! -r /proc/kmsg ]; then
    echo ""
    echo "This program should be run as root."
    echo ""
    exit 1
fi

DBUSDAEMON="/etc/init.d/messagebus"
HALDAEMON="/etc/init.d/haldaemon"

##
## Checking dbus-daemon.  (messagebus)
if ! pgrep -f "dbus-daemon --system" > /dev/null 2>&1; then
    # Dbus system daemon is not running.

    echo "`date +"%b %d %T"` [$ProgramName]: Start dbus-daemon.." >> $logfile
    $DBUSDAEMON restart

    echo "`date +"%b %d %T"` [$ProgramName]: Start hal-daemon.." >> $logfile
    $HALDAEMON restart

    exit 0
fi

##
## Checking hal-daemon.  (hald)
if ! $HALDAEMON status > /dev/null 2>&1; then
    echo "`date +"%b %d %T"` [$ProgramName]: Start hal-daemon.." >> $logfile
    $HALDAEMON restart
fi
