#!/bin/bash
#
#  umx-start-x.sh
#
#    Start X server. For now, only deal with Multi-X server
#
#    Copyright (c) 2002-2008 Userful Corporation
#
#    Jason Kim <jason@userful.com>
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
XINITRC="/opt/userful/umx.xinitrc"

if which lspci > /dev/null 2>&1; then
    LSPCI="lspci"
else
    LSPCI="/opt/userful/bin/listpci"
fi

# Update userful.Mxorg.conf for the input devices not required.
# For now, check TouchScreen and update config file.
function update_mx_config()
{
    NUM_OF_HEADS=`cat /etc/X11/stations`

    if ! grep "tch" /etc/usbinput > /dev/null 2>&1 ; then
        # No touchscreen device in the /etc/usbinput.
        # Remove Touch from ServerLayout in the userful.Mxorg.conf
        for ((i = 0; i < $NUM_OF_HEADS; i++))
        do
            TEST=`grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch$i"`
            if [ -n "$TEST" ]; then
                sed -i -e "/$TEST/d" /etc/X11/userful.Mxorg.conf
            fi
        done

    elif ! grep "InputDevice" /etc/X11/userful.Mxorg.conf | grep "Touch" > /dev/null 2>&1 ; then
        # Touchscreen exist in the /etc/usbinput, but no Touch entry in the ServerLayout section
        # Regenerate userful.Mxorg.conf
        echo "(II) Touchscreen detected. Create userful.Mxorg.conf with touchscreen infomation" >>  $logfile
        if [ -f /root/xorg.conf.new ]; then
            /opt/userful/bin/dm-gen-xconfig.sh -1box
        else
            /opt/userful/bin/mx-config-gen.sh -1box
        fi
    fi
}

source /opt/userful/bin/userful-bash-lib.sh 
init_message "  Starting \E[36mUSERFUL Multiplier\033[0m. Please wait..."

source /etc/userful/MXVERSION
if [ -z "$MXVER" ]; then
	log "Unable to find /etc/X11/MXVERSION file. Set MXVER to MX11R7"
    MXVER="MX11R7"
fi

# Checks the hotplugging of USB hubs or input devices
if [ -x /opt/userful/bin/waiting-for.sh ]; then
    /opt/userful/bin/waiting-for.sh --hub -interval 3
    /opt/userful/bin/waiting-for.sh --input -interval 2
fi

# load nvidia module if nvidia driver exist
if $LSPCI -n | grep "0300:" | tr "a-z" "A-Z" | grep "10DE" > /dev/null 2>&1 ; then
	modprobe -q nvidia
    #if [ -e /usr/lib/xorg/modules/drivers/nvidia_drv.o -o \
	#	-e /usr/lib64/xorg/modules/drivers/nvidia_drv.o -o \
	#	-e /usr/X11R6/lib64/modules/drivers/nvidia_drv.o -o \
	#	-e /usr/X11R6/lib/modules/drivers/nvidia_drv.o ]; then
	#	modprobe -q nvidia
	#fi
fi

#reset PS/2 device if needed
/opt/userful/bin/checkPS2

# create usbinput config file
/opt/userful/bin/make-config-file 2>> $logfile

# Check Mandatory device
if [ -f /opt/userful/bin/umx-mandatory-dev-refresh.sh ]; then
    /opt/userful/bin/umx-mandatory-dev-refresh.sh
fi

# update userful.Mxorg.conf before X starts
update_mx_config

# export LD_LIBRARY_PATH
if [ "$MXVER" == "MX11R7" ]; then
    export LD_LIBRARY_PATH=/opt/MX11R7/lib
fi

##
## Add /opt/MX11R7/lib to ld.conf.cache
ldconfig /opt/MX11R7/lib/
RET=$?
while [[ "$RET" != "0" ]];
do
    sleep 1
	log "ldconfig has failed. Try again."
    ldconfig /opt/MX11R7/lib/
    RET=$?
done

# Source umx.conf
#  - Find LOGINTYPE (remote, local or auto)
#  - Find video configuration
if [ -f /tmp/distro.conf ]; then
    source /tmp/distro.conf
fi
if [ -f /etc/userful/umx.conf ]; then
    sed -e "s/^\[/#\[/g" /etc/userful/umx.conf > /tmp/umx.conf.tmp
    source /tmp/umx.conf.tmp
fi

##
## Set the X options to start
if [ "$LOGINTYPE" == "remote" ]; then
    TCP_CONNECTION=""
else
    TCP_CONNECTION="-nolisten tcp"
fi

IGNOREABI="-ignoreABI"

if [ "$ACCESS_CONTROL" == "enable" ]; then
    AC=""
else
    AC="-ac"
    TCP_CONNECTION=""
fi

##
## Create /tmp/X-start and /tmp/waiting-for-x
if which date > /dev/null 2>&1; then
    date +%s > /tmp/X-start
    # waiting-for.sh --xorg will be paused until it find /tmp/waiting-for-x file.
    touch /tmp/waiting-for-x
else
    rm -f /tmp/X-start
fi

## Video initialization will be happen dm-config-mx.sh
## Checks VIDEO_RESET 
#if [ "$VIDEO_RESET" == "enable" ]; then
#    touch /tmp/video-reset
#    xinit $XINITRC -- /opt/$MXVER/bin/X :0 $IGNOREABI -br -logfile /var/log/1box-server.log $TCP_CONNECTION -config userful.Mxorg.conf
#fi

# Start Multi X server
log "Start %s." "$MXVER"
exec xinit $XINITRC -- /opt/$MXVER/bin/X :0 $IGNOREABI -br -logfile /var/log/1box-server.log $TCP_CONNECTION $AC -config userful.Mxorg.conf &>/dev/null
