#!/bin/bash

#
# Copyright (c) 2004-2006 by Userful Corporation
#
# Name: multistation-devices-update-ownership.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#
# Called from: GDM pam when user log in and out from session
#
# Available environment variables:
# $PAM_TTY, $PAM_FUNCTION, $PAM_USER
###################################################################################

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

## update permission of logfile and config files
touch $logfile
chmod a+w $logfile

touch /etc/usbhub
chmod a+r /etc/usbhub

touch /etc/usbinput
chmod a+r /etc/usbinput

touch /etc/usbaudio
chmod a+r /etc/usbaudio

touch /etc/multiuserdevices
chmod a+r /etc/multiuserdevices

if [ "$PAM_TTY" == "" -o "$PAM_FUNCTION" == "" -o "$PAM_USER" == "" ]; then
	echo "`date +"%b %d %T"` $ProgramName: Unable to get all PAM environment variables" >> $logfile
	echo "`date +"%b %d %T"` $ProgramName: PAM_TTY=$PAM_TTY, PAM_FUNCTION=$PAM_FUNCTION, PAM_USER=$PAM_USER" >> $logfile

	# Fail to login
	exit 1
fi

if [ "$PAM_FUNCTION"  == "OPEN_SESSION" ]; then

	echo "`date +"%b %d %T"` $ProgramName:(Login) $PAM_USER login to DISPLAY=$PAM_TTY" >> $logfile
	#SCREEN_NUM=${PAM_TTY:1}
    # Get Display number for both local and remote display
	SCREEN_NUM=${PAM_TTY##*:}
	SCREEN_NUM=${SCREEN_NUM/.*}

	if [ -e /etc/startat ]; then
		STARTAT=`cat /etc/startat`
	fi

	if test x"$STARTAT" == x; then
		# no value for STARTAT 
		STATION_NUM=$(($SCREEN_NUM + 1))
	else
		STATION_NUM=$(($SCREEN_NUM + $STARTAT))
	fi

    # Create files that contains SCREEN/STATION number in it
	echo "$STATION_NUM" > /opt/userful/locks/station.$PAM_USER
	echo "$SCREEN_NUM" > /opt/userful/locks/screen.$PAM_USER

	PAM_USER_ID=`id -u $PAM_USER`
	echo "$STATION_NUM" > /opt/userful/locks/station.$PAM_USER_ID
	echo "$SCREEN_NUM" > /opt/userful/locks/screen.$PAM_USER_ID

    # Create a file that contains USER name in it.
    echo "$PAM_USER" > /opt/userful/locks/user.screen$SCREEN_NUM

    ###########
    # For DST4
    ###########
    if [ -x /opt/userful/bin/dstv4_change_audio_ownership.sh ]; then
        /opt/userful/bin/dstv4_change_audio_ownership.sh $PAM_USER
    fi

elif [ "$PAM_FUNCTION"  == "CLOSE_SESSION" ]; then

	echo "`date +"%b %d %T"` $ProgramName:(Logout) $PAM_USER logout from DISPLAY=$PAM_TTY" >> $logfile
	SCREEN_NUM=${PAM_TTY:1}
	SCREEN_NUM=${SCREEN_NUM/.*}

	rm -f /opt/userful/locks/station.$PAM_USER
	rm -f /opt/userful/locks/screen.$PAM_USER

	PAM_USER_ID=`id -u $PAM_USER`
	rm -f /opt/userful/locks/station.$PAM_USER_ID
	rm -f /opt/userful/locks/screen.$PAM_USER_ID

    rm -f /opt/userful/locks/user.screen$SCREEN_NUM

	if [ "$PAM_USER" != "root" ]; then
        if [ -f /etc/init.d/Userful-Desktop-startup ]; then
            :
        else
            # TODO:
            #   - may need a better way to clean up for the logout user
            #   - dbus-launch 
			su -c '/opt/userful/bin/gconf.sh --restore_all' $PAM_USER
            killall -u $PAM_USER
        fi
    fi

    # send HUP signal to KDM when a user logs out.
    #if [ -f /etc/userful/currentdm -a -f /var/run/kdm.pid ]; then
    #    source /etc/userful/currentdm
    #    if [ "$CURRENTDM" == "kdm" ]; then
    #        sleep 2
    #        kill -HUP `cat /var/run/kdm.pid`
    #    fi
    #fi
fi

if [ -x /opt/userful/bin/multistation-audio-update-ownership.sh ]; then
	/opt/userful/bin/multistation-audio-update-ownership.sh $PAM_TTY $PAM_FUNCTION $PAM_USER
fi

if [ -x /opt/userful/bin/multistation-storage-update-ownership.sh ]; then
	/opt/userful/bin/multistation-storage-update-ownership.sh $PAM_TTY $PAM_FUNCTION $PAM_USER
fi
