#!/bin/bash

# NAME
#   multistation-audio-uninstall.sh
#
# AUTHOR
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
# 	- pre-script before uninstallation.
# 	- Restore updated files during uninstall.

# Restore gdm pam module
if [ ! -f /opt/userful/bin/multistation-storage-config.sh -a -e /etc/pam.d/gdm ]; then
	#
	# disable pam_console for FC
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
		NEW_PAM_MODULE=${PAM_MODULE:1}
		sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
	fi

	#
	# disable pam_devperm for SuSE
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
		NEW_PAM_MODULE=${PAM_MODULE:1}
		sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
	fi
fi

if [ -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save ]; then
    mv -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi
fi

if [ -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-multimedia-policy.fdi ]; then #FC6
	rm -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-multimedia-policy.fdi
fi
