#!/bin/bash

#****** gconf_audio.sh
# NAME
# 	gconf_audio.sh
#
# AUTHOR
# 	Rocky
#
# DESCRIPTION
# 	Inital shell script for multiuser audio in every session startup.
# 	The process includes:
# 	1) Modify gconf to make Dsktop default web link use aoss command (e.g. web link in OO)
# SOURCE
#
# TODO:
# 	This is not used in DM. Need to test with DST.

# fedora_core_release=`cat /etc/fedora-release |awk '{print $1,$2}'`

	if [ -e /etc/fedora-release ]; then
		linux_distribution="Fedora"
	elif [ -e /etc/SuSE-release ]; then
		linux_distribution="Suse"
	elif [ -e /etc/mandrake-release ] || [ -e /etc/mandrakelinux-release ]; then
		linux_distribution="Mandrake"
   	elif [ -e /etc/debian-release ]; then
   		linux_distribution="Debian"
   	else
   		linux_distribution="Unknown"
   	fi

	default_launch_web_browser=`gconftool-2 -g /desktop/gnome/url-handlers/http/command |awk '{print $1}'`

	default_launch_web_browser=`/bin/basename $default_launch_web_browser`

	if [ -x /opt/userful/bin/launch-web-browser.sh ] && [ "$linux_distribution" = "Fedora" ]; then
		gconftool-2 -s /desktop/gnome/url-handlers/about/command --type string "/opt/userful/bin/launch-web-browser.sh %s"
		gconftool-2 -s /desktop/gnome/url-handlers/http/command --type string "/opt/userful/bin/launch-web-browser.sh %s"
		gconftool-2 -s /desktop/gnome/url-handlers/https/command --type string "/opt/userful/bin/launch-web-browser.sh %s"
		gconftool-2 -s /desktop/gnome/url-handlers/unknown/command --type string "/opt/userful/bin/launch-web-browser.sh %s"

	elif [ $default_launch_web_browser != "userful_launch_web_browser.sh" ] && [ "$linux_distribution" = "Fedora" ]; then
   		if [ ! -e ~/userful_launch_web_browser.sh ]; then
      		cp -f /opt/userful/bin/userful_launch_web_browser.sh ~
   		fi
   		gconftool-2 -s /desktop/gnome/url-handlers/about/command --type string "./userful_launch_web_browser.sh %s"
   		gconftool-2 -s /desktop/gnome/url-handlers/http/command --type string "./userful_launch_web_browser.sh %s"
   		gconftool-2 -s /desktop/gnome/url-handlers/https/command --type string "./userful_launch_web_browser.sh %s"
   		gconftool-2 -s /desktop/gnome/url-handlers/unknown/command --type string "./userful_launch_web_browser.sh %s"

	fi

#***
