/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Measure implements Serializable{
	public static final int CLEF_TREBLE = 1;	
	public static final int CLEF_BASS = 2;	
	public static final int CLEF_TENOR = 3;	
	public static final int CLEF_ALTO = 4;
	
    private MeasureHeader header;
	private int clef;
	private int keySignature;
    private List notes;
    private List silences;
    
    public Measure(MeasureHeader header,List notes,List silences,int clef,int keySignature){
        this.header = header;
    	this.notes = notes;
        this.silences = silences;
        this.clef = clef;
        this.keySignature = keySignature;
    }
    
    

    public int getClef() {
		return clef;
	}

	public void setClef(int clef) {
		this.clef = clef;
	}

	public int getKeySignature() {
		return keySignature;
	}

	public void setKeySignature(int keySignature) {
		this.keySignature = keySignature;
	}

	public List getNotes() {
        return notes;
    }
    public void setNotes(List notes) {
        this.notes = notes;
    }          
    
    public void removeNote(Note note){
        this.notes.remove(note);
    }    
    public void addNote(Note note){
        this.notes.add(note);
    }    
    public List getSilences() {
        return silences;
    }
    public void setSilences(List silences) {
        this.silences = silences;
    }
    public void removeSilence(Silence silence){
        this.silences.remove(silence);
    }    
    public void addSilence(Silence silence){
        this.silences.add(silence);
    }    
    
    public MeasureHeader getHeader() {
		return header;
	}

	public void setHeader(MeasureHeader header) {
		this.header = header;
	}

	public int getNumber() {
		return header.getNumber();
	}

	public int getNumberOfRepetitions() {
		return header.getNumberOfRepetitions();
	}

	public long getStart() {
		return header.getStart();
	}

	public long getStartWidthRepetitions() {
		return header.getStartWidthRepetitions();
	}

	public Tempo getTempo() {
		return header.getTempo();
	}

	public TimeSignature getTimeSignature() {
		return header.getTimeSignature();
	}

	public boolean isRepeatStart() {
		return header.isRepeatStart();
	}

	public int getTripletFeel() {
		return header.getTripletFeel();
	}

	public long getLength() {
		return header.getLength();
	}

	public boolean hasMarker() {
		return header.hasMarker();
	}

	public Marker getMarker(){
		return header.getMarker();
	}
	
	public void makeEqual(Measure measure){
        this.clef = measure.getClef();
        this.keySignature = measure.getKeySignature();
        this.notes = measure.getNotes();
        this.silences = measure.getSilences();        
    }
	
    public Object clone(MeasureHeader header){
        int clef = this.clef;
        int keySignature = this.keySignature;
        List notes = new ArrayList();
        List silences = new ArrayList();       
        for(int i = 0;i < this.notes.size();i++){
            Note note = (Note)this.notes.get(i);
            notes.add(note.clone());
        }
        for(int i = 0;i < this.silences.size();i++){
            Silence silence = (Silence)this.silences.get(i);
            silences.add(silence.clone());
        }       
        return new Measure(header,notes,silences,clef,keySignature);
    }
    
}
