package org.herac.tuxguitar.song.helpers;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.models.MeasureHeader;

public class TracksMeasures {
	private List measureHeaders;
	private List trackMeasures;
	
	public TracksMeasures(){
		this.measureHeaders = new ArrayList();
		this.trackMeasures = new ArrayList();
	}
	
	public List getMeasureHeaders() {
		return measureHeaders;
	}

	public void setMeasureHeaders(List measureHeaders) {
		this.measureHeaders = measureHeaders;
	}

	public List getTrackMeasures() {
		return trackMeasures;
	}

	public void addTrackMeasure(long track,List measures){
		this.trackMeasures.add(new TrackMeasure(track,measures));
	}

	public boolean isEmpty(){
		return (measureHeaders.isEmpty() || trackMeasures.isEmpty());
	}
	
	public Object clone(){				
		List measureHeaders = new ArrayList();
		for(int i = 0;i < getMeasureHeaders().size();i++){
			MeasureHeader header = (MeasureHeader)getMeasureHeaders().get(i);
			measureHeaders.add(header.clone());
		}
		List trackMeasures = new ArrayList();
		for(int i = 0;i < getTrackMeasures().size();i++){
			TrackMeasure trackMeasure = (TrackMeasure)getTrackMeasures().get(i);
			trackMeasures.add(trackMeasure.clone(measureHeaders));
		}
		
		TracksMeasures tracksMeasures = new TracksMeasures();
		tracksMeasures.measureHeaders = measureHeaders;
		tracksMeasures.trackMeasures = trackMeasures;
		
		return tracksMeasures;
	}
	
}
