package org.herac.tuxguitar.io.exporter;

import java.io.PrintStream;
import java.io.PrintWriter;

import org.eclipse.swt.graphics.Point;

public class ASCIIOutputStream {
	private PrintWriter writer;
	private int x;
	private int y;

	public ASCIIOutputStream(PrintStream stream){
		this.writer = new PrintWriter(stream);
	}
	
	public void drawNote(int fret){		
		movePoint(x + ((fret >=10 )?2:1),y);
		this.writer.print(fret);
	}
	
	public void drawStringSegments(int count){
		movePoint(x + count,y);
		for(int i = 0; i < count;i ++){
			this.writer.print("-");
		}
	}

	public void drawTuneSegment(String tune,int maxLength){
		for(int i = tune.length();i < maxLength;i ++){
			drawSpace();
		}
		movePoint(x + tune.length(),y);
		this.writer.print(tune);		
	}
	
	public void drawBarSegment(){
		movePoint(x + 1,y);
		this.writer.print("|");		
	}
	
	public void nextLine(){
		movePoint(0,y + 1);
		this.writer.println("");
	}

	public void drawStringLine(String s){
		movePoint(0,y + 1);
		this.writer.println(s);
	}
	
	public void drawSpace(){
		movePoint(x + 1,y);
		this.writer.print(" ");		
	}
	
	
	private void movePoint(int x,int y){
		this.x = x;
		this.y = y;
	}
	
	public Point getPosition(){
		return new Point(x,y);
	}

	public void flush(){
		this.writer.flush();
	}


	public void close(){
		this.writer.close();
	}
		
	
}
