package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;

public class SplashShell {
	private Shell shell;
	
	public SplashShell(Display display){
		if(TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.SHOW_SPLASH)){
			this.open(display);
		}
	}

	private void open(Display display) {				
		final Image image = SystemImages.TUXGUITAR_SPLASH;
		int width = image.getBounds().width;
		int height = image.getBounds().height;
		int x = ((display.getBounds().width - display.getBounds().x) / 2) - (width / 2);
		int y = ((display.getBounds().height - display.getBounds().y) / 2) - (height / 2);
		
		this.shell = new Shell(display, SWT.NO_TRIM | SWT.NO_BACKGROUND);
		this.shell.setBounds(x, y, width, height);
		this.shell.setImage(SystemImages.TUXGUITAR_ICON);
		this.shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
		this.shell.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(image, 0, 0);
			}
		});
		this.shell.open();
	}
	
	public void close(){
		if(this.shell != null && !this.shell.isDisposed()){
			this.shell.close();
			this.shell.dispose();
		}
	}
}
