package org.herac.tuxguitar.gui.system.keybindings;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.system.keybindings.xml.KeyBindingReader;
import org.herac.tuxguitar.gui.system.keybindings.xml.KeyBindingWriter;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class KeyBindingManager {
	private static KeyBindingManager instance;
	private Map keyBindings;
	private KeyBindingListener kbl;
	
	public KeyBindingManager(){ 
		this.keyBindings = new HashMap();
	}
	
	public void init(){
		Map userKeyBindings = KeyBindingReader.getKeyBindings(getUserFileName());
		if(userKeyBindings != null){
			this.keyBindings.putAll(userKeyBindings);	
		}else{
			userKeyBindings = KeyBindingDefaults.getDefaultKeyBindings();
			this.keyBindings.putAll(userKeyBindings);
			this.saveKeyBindings();
		}
		this.kbl = new KeyBindingListener();
	}

    private String getUserFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "keybindings.xml";
    }
    
    public Action getActionForKeyBinding(KeyBinding kb){
    	return (Action)keyBindings.get(kb);
    }
    
    public void removeAction(KeyBinding kb){
    	keyBindings.remove(kb);
    }

    public void reset(Map keyBindings){
    	this.keyBindings.clear();
    	this.keyBindings.putAll(keyBindings);
    }
    
    public Set getKeyBindings(){
    	return keyBindings.keySet();
    }
    
    public void saveKeyBindings(){
    	KeyBindingWriter.setBindings(getKeyBindings(),getUserFileName());
    }
    
    public void appendListenersTo(Composite c){
    	c.addKeyListener(kbl);
    }
    
    class KeyBindingListener implements KeyListener {

		public void keyPressed(KeyEvent evt) {
			KeyBinding kb = new KeyBinding();
			kb.setKey(evt.keyCode);
			kb.setMask(evt.stateMask);
			
			Action a = (Action)keyBindings.get(kb);			
			if (a != null){
				a.process(evt);				
			}
		}

		public void keyReleased(KeyEvent evt) {
			
		}
    	
    }
}
