/*
 * Created on 27-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.system.config;

import java.io.InputStream;
import java.util.Properties;

import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ConfigDefaults{
    private Properties properties;
    
    public ConfigDefaults(){
        this.properties = new Properties();
        this.loadDefaults();
        this.loadDefaultFile();   
    }
    
    public void loadDefaultFile() {       
        try {        
        	InputStream is = TuxGuitarFileUtils.getResourceAsStream("defaults.properties");
        	if(is != null){
        		this.properties.load(is);
        	}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }    
    
    private void loadDefaults(){
    	this.loadProperty(ConfigKeys.WINDOW_TITLE,"${appname} - ${filename}");
    	this.loadProperty(ConfigKeys.SHOW_SPLASH,true);    	
    	this.loadProperty(ConfigKeys.MAXIMIZED,false);
        this.loadProperty(ConfigKeys.WIDTH,800);
        this.loadProperty(ConfigKeys.HEIGHT,600);               
        this.loadProperty(ConfigKeys.SHOW_MIXER,false);
        this.loadProperty(ConfigKeys.SHOW_TRANSPORT,false);
        this.loadProperty(ConfigKeys.SHOW_FRETBOARD,false);
        this.loadProperty(ConfigKeys.SHOW_PIANO,false);
        this.loadProperty(ConfigKeys.LAYOUT_MODE,2);
        this.loadProperty(ConfigKeys.SHOW_MULTITRACK,true);
        this.loadProperty(ConfigKeys.SHOW_SCORE,true);        
        this.loadProperty(ConfigKeys.SHOW_TABLATURE,true);
        this.loadProperty(ConfigKeys.EDITOR_MOUSE_MODE,EditorKit.MOUSE_MODE_EDITION);
        this.loadProperty(ConfigKeys.EDITOR_NATURAL_KEY_MODE,true);
        this.loadProperty(ConfigKeys.FONT_DEFAULT,"Sans,6,2");
        this.loadProperty(ConfigKeys.FONT_NOTE,"Sans,7,1");        
        this.loadProperty(ConfigKeys.FONT_TIME_SIGNATURE,"Sans,13,3");                   
        this.loadProperty(ConfigKeys.FONT_PRINTER_DEFAULT,"Sans,6,2");                 
        this.loadProperty(ConfigKeys.FONT_PRINTER_NOTE,"Sans,6,0");
        this.loadProperty(ConfigKeys.FONT_PRINTER_TIME_SIGNATURE,"Sans,12,3");
        this.loadProperty(ConfigKeys.FONT_LYRIC,"Sans,7,2");
        this.loadProperty(ConfigKeys.FONT_GRACE,"Sans,6,0");        
        this.loadProperty(ConfigKeys.FONT_ABOUT_DIALOG_TITLE,"Serif,36,3");          
        this.loadProperty(ConfigKeys.COLOR_LINE,"150,150,150");
        this.loadProperty(ConfigKeys.COLOR_SCORE_NOTE,"0,0,0");       
        this.loadProperty(ConfigKeys.COLOR_TAB_NOTE,"0,0,0");       
        this.loadProperty(ConfigKeys.COLOR_PLAY_NOTE,"255,0,0");             
        this.loadProperty(ConfigKeys.MAX_HISTORY_FILES,10);
        this.loadProperty(ConfigKeys.AUTO_SPACING_ENABLE,true);
        this.loadProperty(ConfigKeys.MIN_SCORE_TABLATURE_SPAN,20);    
        this.loadProperty(ConfigKeys.SCORE_LINE_SPAN,8);
        this.loadProperty(ConfigKeys.TAB_LINE_SPAN,10);    
        this.loadProperty(ConfigKeys.FIRST_TRACK_SPAN,25);
        this.loadProperty(ConfigKeys.TRACK_SPAN,10);        
        this.loadProperty(ConfigKeys.FRETBOARD_STRING_SPAN,20);        
        this.loadProperty(ConfigKeys.LANGUAGE,"");
        this.loadProperty(ConfigKeys.SOUNDBANK_CUSTOM,false);                            
        this.loadProperty(ConfigKeys.SYSTEM_PLAYER,"org.herac.tuxguitar.player.impl.MidiPlayerImpl");        
        this.loadProperty(ConfigKeys.TABLATURE_FLAGS,Tablature.ALLOW_PLAY_CACHE);
    }
    
    public Properties getProperties() {      
        return this.properties;        
    }        

    private void loadProperty(String key,String value){
    	this.properties.setProperty(key,value);
    }
    
    private void loadProperty(String key,int value){
    	this.properties.setProperty(key,Integer.toString(value));
    }
    
    private void loadProperty(String key,boolean value){    	
    	this.properties.setProperty(key,Boolean.toString(value));
    }

}
