package org.herac.tuxguitar.gui.scale;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.herac.tuxguitar.gui.scale.xml.ScaleReader;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;
import org.herac.tuxguitar.song.models.MusicScale;
import org.xml.sax.SAXException;

public class MusicScaleManager {
	private static final String[] KEY_NAMES = new String[]{"C","C#","D","D#","E","F","F#","G","G#","A","A#","B"};
	
	private static final String KEY_SEPARATOR = ",";
	
	public static final int NONE_SELECTION = -1;
	
	private List scales;
	
	private MusicScale scale;
	
	private int selectionIndex;
	
	private int selectionKey;
	
	public MusicScaleManager(){
		this.scales = new ArrayList();
		this.scale = new MusicScale();		
		this.selectionKey = 0;
		this.selectionIndex = NONE_SELECTION;
		this.loadScales();
	}
			
	public MusicScale getScale() {
		return scale;
	}		

	public void selectScale(int index,int key){
		if(index == NONE_SELECTION){
			getScale().clear();
		}
		else if(index >= 0 && index < scales.size()){		
			getScale().clear();
			ScaleInfo info = (ScaleInfo)scales.get(index);
			String[] keys = info.getKeys().split(KEY_SEPARATOR);						
			for (int i = 0; i < keys.length; i ++){
				int note = (Integer.parseInt(keys[i]) - 1);
				if(note >= 0 && note < 12){
					getScale().setNote(note,true);
				}
			}					
			getScale().setKey(key);
		}
		this.selectionIndex = index;
		this.selectionKey = key;
	}
	
	public String[] getScaleNames(){
		String[] names = new String[this.scales.size()];
				
		Iterator it = this.scales.iterator();		
		for(int i = 0;i < scales.size();i ++){
			ScaleInfo info = (ScaleInfo)scales.get(i);
			names[i] = info.getName();
		}
		
		return names;
	}

	public String[] getKeyNames(){
		return KEY_NAMES;
	}
	
	public int getSelectionIndex() {
		return selectionIndex;
	}

	public int getSelectionKey() {
		return selectionKey;
	}

	private void loadScales(){
		try{
			new ScaleReader().loadScales(scales,getScalesFileName());
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} catch (Error e) {
			e.printStackTrace();
		}
	}
	
    private String getScalesFileName(){
    	return TuxGuitarFileUtils.SCALES_PREFIX + File.separator + "scales.xml";
    }	


}
