package org.herac.tuxguitar.gui.marker;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Marker;

public class MarkerNavigator {

	public MarkerNavigator(){		
	}
	
	public void goToSelectedMarker(Marker marker){                                
        if(marker != null){
        	Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        	SongTrackCoords track = caret.getSongTrackCoords();
        	MeasureCoords measure = null;        	
        	if(track != null){
        		measure = track.getMeasure(TuxGuitar.instance().getSongManager().getTrackManager().getMeasure(track.getTrack(),marker.getMeasure()));
        	}        	
            if(track != null && measure != null){
            	caret.update(track.getTrack().getNumber(), measure.getMeasure().getStart(),1);
                caret.setChanges(true);
                TuxGuitar.instance().redraw();
            }	     	    
        }		
	}
}
