package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ToolBarsWriter {

	private static final String ITEM_LIST_TAG = "toolbars";
	private static final String ITEM_TAG = "toolbar";
	private static final String NAME_ATTRIBUTE = "name";
	
	public void saveToolBars(List items,String fileName) {    	
        File file = new File(fileName);
        
        Document doc = createDocument();
        setToolBars(items,doc);
        saveDocument(doc,file);        
    }
	
    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } 
        return document;
    }
    
    public static void saveDocument(Document document,File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);

            // Write it out again
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            Source input = new DOMSource(document);            
            Result output = new StreamResult(fs);
            idTransform.setOutputProperty(OutputKeys.INDENT, "yes");
            idTransform.transform(input, output);

        } catch (FactoryConfigurationError e) {
            e.printStackTrace();
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }


    private static void setToolBars(List items,Document document){    
    	//chords tag
    	Node listNode = document.createElement(ITEM_LIST_TAG);

    	Iterator it = items.iterator();
    	while(it.hasNext()){
    		String name = (String)it.next();
    		
    		//chord tag
    		Node node = document.createElement(ITEM_TAG);
    		listNode.appendChild(node);    
    	
    		//name attribute
    		Attr attribute = document.createAttribute(NAME_ATTRIBUTE);    	
    		attribute.setNodeValue( name);    	
    		node.getAttributes().setNamedItem(attribute);    		
    	}
    	
    	document.appendChild(listNode);    
    }
        
}
