package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolBarsReader {
	private static final String ITEM_LIST_TAG = "toolbars";
	private static final String ITEM_TAG = "toolbar";
	private static final String NAME_ATTRIBUTE = "name";
	
    public List loadToolBars(File file){
    	List items = new ArrayList();    	  
        if (file.exists()){
			try {
				Document doc = getDocument(file);
				loadToolBars(items,doc.getFirstChild());
			} catch (ParserConfigurationException e) {
				e.printStackTrace();
			} catch (SAXException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} catch (Exception e) {
        	    e.printStackTrace();
        	} catch (Error e) {
        		e.printStackTrace();
        	}   	
        }      
        
        return items;
    }
    
    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(file);
        
        
        return document;
    }

    private static void loadToolBars(List items,Node node){
        NodeList listNode = node.getChildNodes();
        for (int i = 0; i < listNode.getLength(); i++) {
            Node child = listNode.item(i);
            String nameNode = child.getNodeName();

            if (nameNode.equals(ITEM_TAG)) {
            	NamedNodeMap params = child.getAttributes();

            	String name = params.getNamedItem(NAME_ATTRIBUTE).getNodeValue();            	            	            	
            	if (name == null || name.trim().length() == 0){
            		System.err.println("Invalid ToolBar name.");
            	}            	
            	items.add(name);
            }
        }
    }
}
