/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.note.ChangeVelocityAction;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.VelocityValues;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DynamicToolItems  extends ToolItems{
    public static final String NAME = "dynamic.items";
    
    private ToolBar toolBar;

    private ToolItem pianoPianissimo;
    private ToolItem pianissimo;
    private ToolItem piano;
    private ToolItem mezzoPiano;
    private ToolItem mezzoForte;
    private ToolItem forte;
    private ToolItem fortissimo;
    private ToolItem forteFortissimo;
    
		
    public DynamicToolItems(){
    	super(NAME);
    }
   
    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;         
        //--PPP--
        this.pianoPianissimo = new ToolItem(this.toolBar, SWT.CHECK); 
        this.pianoPianissimo.setImage(SystemImages.DYNAMIC_PIANO_PIANISSIMO);
        this.pianoPianissimo.setData(new Integer(VelocityValues.PIANO_PIANISSIMO));
        this.pianoPianissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        //--PP--
        this.pianissimo = new ToolItem(this.toolBar, SWT.CHECK);
        this.pianissimo.setImage(SystemImages.DYNAMIC_PIANISSIMO);
        this.pianissimo.setData(new Integer(VelocityValues.PIANISSIMO));
        this.pianissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));

        //--P--
        this.piano = new ToolItem(this.toolBar, SWT.CHECK);
        this.piano.setImage(SystemImages.DYNAMIC_PIANO);
        this.piano.setData(new Integer(VelocityValues.PIANO));
        this.piano.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        //--MP--
        this.mezzoPiano = new ToolItem(this.toolBar, SWT.CHECK);
        this.mezzoPiano.setImage(SystemImages.DYNAMIC_MEZZO_PIANO);
        this.mezzoPiano.setData(new Integer(VelocityValues.MEZZO_PIANO));
        this.mezzoPiano.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));

        //--MF--
        this.mezzoForte = new ToolItem(this.toolBar, SWT.CHECK);
        this.mezzoForte.setImage(SystemImages.DYNAMIC_MEZZO_FORTE);
        this.mezzoForte.setData(new Integer(VelocityValues.MEZZO_FORTE));
        this.mezzoForte.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        //--F--
        this.forte = new ToolItem(this.toolBar, SWT.CHECK);
        this.forte.setImage(SystemImages.DYNAMIC_FORTE);
        this.forte.setData(new Integer(VelocityValues.FORTE));
        this.forte.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));

        //--FF--        
        this.fortissimo = new ToolItem(this.toolBar, SWT.CHECK);
        this.fortissimo.setImage(SystemImages.DYNAMIC_FORTISSIMO);
        this.fortissimo.setData(new Integer(VelocityValues.FORTISSIMO));
        this.fortissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        //--FF--        
        this.forteFortissimo = new ToolItem(this.toolBar, SWT.CHECK);
        this.forteFortissimo.setImage(SystemImages.DYNAMIC_FORTE_FORTISSIMO);
        this.forteFortissimo.setData(new Integer(VelocityValues.FORTE_FORTISSIMO));
        this.forteFortissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));

        this.loadProperties();
    }
 
    
    public void update(){
    	Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    	int velocity = ((caret.getSelectedNote() != null)?caret.getSelectedNote().getVelocity():caret.getVelocity());    	
        this.pianoPianissimo.setSelection(velocity == VelocityValues.PIANO_PIANISSIMO);
        this.pianissimo.setSelection(velocity == VelocityValues.PIANISSIMO);
        this.piano.setSelection(velocity == VelocityValues.PIANO);
        this.mezzoPiano.setSelection(velocity == VelocityValues.MEZZO_PIANO);
        this.mezzoForte.setSelection(velocity == VelocityValues.MEZZO_FORTE);
        this.forte.setSelection(velocity == VelocityValues.FORTE);
        this.fortissimo.setSelection(velocity == VelocityValues.FORTISSIMO);
        this.forteFortissimo.setSelection(velocity == VelocityValues.FORTE_FORTISSIMO);
    }
           
    public void loadProperties(){
        this.pianoPianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.pianissimo"));     
        this.piano.setToolTipText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-piano"));        
        this.mezzoForte.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-forte"));        
        this.forte.setToolTipText(TuxGuitar.getProperty("dynamic.forte"));      
        this.fortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.fortissimo"));   
        this.forteFortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }       
}

