/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.MeasureHeaderGui;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.util.ImageUtils;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class ViewLayout {	
	public static final int MODE_PAGE = 1;
	public static final int MODE_LINEAR = 2; 
	public static final int DEFAULT_MODE = MODE_LINEAR;

    private static final int SCORE_NOTE_EMPTY_NORMAL_MODE = 0;
    private static final int SCORE_NOTE_EMPTY_PLAY_MODE = 1;
    private static final int SCORE_NOTE_FULL_NORMAL_MODE = 2;
    private static final int SCORE_NOTE_FULL_PLAY_MODE = 3;
	
	public static final boolean AUTO_SPACING_ENABLED = TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.AUTO_SPACING_ENABLE);
	protected static final int DEFAULT_HORIZONTAL_SPAN = 20;  
	protected static final int DEFAULT_MIN_TOP_SPAN = 30;
	protected static final int MIN_SCORE_TAB_SPAN =  TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.MIN_SCORE_TABLATURE_SPAN);
	protected static final int DEFAULT_SCORE_LINE_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.SCORE_LINE_SPAN);	
	protected static final int DEFAULT_SCORE_SPAN = ((DEFAULT_SCORE_LINE_SPAN * 4) + MIN_SCORE_TAB_SPAN);
	protected static final int DEFAULT_FIRST_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.FIRST_TRACK_SPAN);
	protected static final int DEFAULT_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.TRACK_SPAN);
	protected static final int DEFAULT_STRING_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.TAB_LINE_SPAN);

	public static final int DEFAULT_EFFECT_SPAN = 8;

    private Tablature tablature;
    private SongManager songManager;        
    private boolean multitrack;
    private boolean scoreEnabled;
    private boolean tablatureEnabled;
    private List trackPositions;
    private int width;
    private int height;
    private int scoreSpan;
    private Image[] scoreNotes;
    private Image[] harmonicNotes;
    private int scoreNoteWidth;
    private boolean playModeEnabled;
    
    public ViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled,boolean tablatureEnabled){
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = multitrack;
        this.scoreEnabled = scoreEnabled;
        this.tablatureEnabled = tablatureEnabled;  
        this.trackPositions = new ArrayList();
        this.playModeEnabled = false;
        this.initScoreNotes();
        this.initHarmonicNotes();
    }
    
    public abstract void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract boolean followMeasure(MeasureCoords measure,boolean redraw);
    
    public abstract int getMode();
    
    public void paint(GC gc,Rectangle clientArea,int fromX,int fromY){
    	paintSong(gc,clientArea,fromX,fromY);
    }
    
    public void paintMeasure(MeasureCoords measureCoords,GC gc,int fromX,int fromY,int span,Rectangle clientArea) {
        measureCoords.setSpan(span);                
        measureCoords.paintMeasure(this,gc,clientArea);
    }    
    
    public void updateSong(){    	
    	disposeTracks();
        updateTracks();       
        updateCaret();        
    }
        
    public void updateTracks() {    	
        int trackCount = getSongManager().countTracks();
        int measureCount = getSongManager().countMeasures();
        getTablature().getSongCoords().create(trackCount, measureCount);
    	
        for (int measureIdx = 0; measureIdx < measureCount; measureIdx++) {        	
        	MeasureHeaderGui header = getTablature().getSongCoords().getHeaderByIndex(measureIdx);
        	header.update(this);
        	for (int trackIdx = 0; trackIdx < trackCount; trackIdx++) {
        		SongTrackCoords trackCoords = getTablature().getSongCoords().getTrackByIndex(trackIdx);
                Measure measure = (Measure) trackCoords.getTrack().getMeasures().get(measureIdx);
                MeasureCoords measureCoords = new MeasureCoords(getSongManager(),getTablature(),header, measure,trackCoords);            
                measureCoords.create(this);                                    
                trackCoords.getMeasuresCoords().add(measureCoords);
        	}           	
        	for (int trackIdx = 0; trackIdx < trackCount; trackIdx++) {
        		SongTrackCoords trackCoords = getTablature().getSongCoords().getTrackByIndex(trackIdx);
        		MeasureCoords measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIdx);                             
                measureCoords.update(this);  
        	} 
        	header.calculateWidth();
    	
        }
        songManager.calculateMeasureStartWithRepetitions();
    }        
   
    public void updateLyrics(){
    	int trackCount = getSongManager().countTracks();
    	for (int i = 0; i < trackCount; i++) {
            SongTrackCoords trackCoords = getTablature().getSongCoords().getTrackByIndex(i);
            trackCoords.getLyricPainter().update();
        }    	
    }

    private void updateCaret(){
    	tablature.getCaret().update();
    }    
    
    public void fireUpdate(int measureNumber,boolean isNew){
    	int measureIndex = (measureNumber - 1);
    	int trackCount = getSongManager().countTracks();    	
    	MeasureHeaderGui header = getTablature().getSongCoords().getHeaderByIndex(measureIndex);    	
    	header.update(this);    	
        for (int trackIdx = 0; trackIdx < trackCount; trackIdx++) {
        	SongTrackCoords trackCoords = getTablature().getSongCoords().getTrackByIndex(trackIdx);
            MeasureCoords measureCoords = null;
            if(isNew){
                Measure measure = (Measure) trackCoords.getTrack().getMeasures().get(measureIndex);
                measureCoords = new MeasureCoords(getSongManager(),getTablature(),header, measure,trackCoords);
                trackCoords.getMeasuresCoords().add(measureCoords);
            }else{
                measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIndex);
            }
            measureCoords.create(this);                        
        } 
        for (int trackIdx = 0; trackIdx < trackCount; trackIdx++) {
        	SongTrackCoords trackCoords = getTablature().getSongCoords().getTrackByIndex(trackIdx);
        	MeasureCoords measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIndex);                 
            measureCoords.update(this);   
        }        	
        header.calculateWidth();    	
        updateCaret();
    }    


    public Image getScoreNote(int value,boolean playMode) {
    	int index = 0;
    	index += ((playMode)?1:0);
    	index += ((value >= Duration.QUARTER)?2:0);    	    	
    	return scoreNotes[index];
    }
    
    public Image getHarmonicNote(int value,boolean playMode) {
    	int index = 0;
    	index += ((playMode)?1:0);
    	index += ((value >= Duration.QUARTER)?2:0);    	    	
    	return harmonicNotes[index];
    }    
    
    private void initScoreNotes(){
    	this.scoreNotes = new Image[4];
    	try{
    		this.scoreNotes[SCORE_NOTE_EMPTY_NORMAL_MODE] = makeScoreNoteImage(tablature.getScoreNoteColor(),false);    	
    		this.scoreNotes[SCORE_NOTE_EMPTY_PLAY_MODE] = makeScoreNoteImage(tablature.getPlayNoteColor(),false);    	
    		this.scoreNotes[SCORE_NOTE_FULL_NORMAL_MODE] = makeScoreNoteImage(tablature.getScoreNoteColor(),true);    	
    		this.scoreNotes[SCORE_NOTE_FULL_PLAY_MODE] = makeScoreNoteImage(tablature.getPlayNoteColor(),true);
    	}catch(SWTException e){
    		this.scoreNotes[SCORE_NOTE_EMPTY_NORMAL_MODE] = makeOldScoreNoteImage(tablature.getScoreNoteColor(),false);    	
    		this.scoreNotes[SCORE_NOTE_EMPTY_PLAY_MODE] = makeOldScoreNoteImage(tablature.getPlayNoteColor(),false);    	
    		this.scoreNotes[SCORE_NOTE_FULL_NORMAL_MODE] = makeOldScoreNoteImage(tablature.getScoreNoteColor(),true);    	
    		this.scoreNotes[SCORE_NOTE_FULL_PLAY_MODE] = makeOldScoreNoteImage(tablature.getPlayNoteColor(),true);
    	}
    }
    
    private void initHarmonicNotes(){
    	this.harmonicNotes = new Image[4];
    	this.harmonicNotes[SCORE_NOTE_EMPTY_NORMAL_MODE] = makeArmonicImage(tablature.getScoreNoteColor(),false);    	
    	this.harmonicNotes[SCORE_NOTE_EMPTY_PLAY_MODE] = makeArmonicImage(tablature.getPlayNoteColor(),false);    	
    	this.harmonicNotes[SCORE_NOTE_FULL_NORMAL_MODE] = makeArmonicImage(tablature.getScoreNoteColor(),true);    	
    	this.harmonicNotes[SCORE_NOTE_FULL_PLAY_MODE] = makeArmonicImage(tablature.getPlayNoteColor(),true);    	
    }    
    
    public int getScoreNoteWidth(){
    	return this.scoreNoteWidth;	
    }
    
    
	private Image makeOldScoreNoteImage(Color color,boolean full) {      
		int size = getScoreLineSpan();
    	Image image = new Image(getTablature().getDisplay(),size,size);
        GC imageGC = new GC(image);              
        imageGC.setAdvanced(true);
        imageGC.setForeground(color);    
    	imageGC.drawOval(0,1,size - 2, size - 2);        
        if(full){
        	imageGC.setBackground(color);        	
        	imageGC.fillOval(0,1,size - 2, size - 2);
        }       
        ImageData src = image.getImageData();  
        ImageData mask = ImageUtils.applyMask(src,new RGB(0xFF,0xFF,0xFF),new RGB(0x00,0x00,0x00));        
        imageGC.dispose();
        image.dispose();
        
        this.scoreNoteWidth = size - 2;
        
        return new Image(getTablature().getDisplay(), src,mask);
    }    
	
    
	private Image makeScoreNoteImage(Color color,boolean full) {  
		int x = 0;
		int y = 1;
    	int size = ((full)?getScoreLineSpan():getScoreLineSpan() - 1) - 1;
    	int width = Math.round(((float)size / (float)3) * 4) +1;
    	int height = size+1;	   

    	//creo el Path
		float offset = ((float)size / (float)3);    	
    	float x1 = x;
    	float y1 = (y + (offset * 2));    	    	
    	float x2 = (x + offset);
    	float y2 = (y + (offset * 3));    	    	
    	float x3 = (x + (offset * 4));
    	float y3 = (y + offset);    	    	
    	float x4 = (x + (offset * 3));
    	float y4 = y;		
    	Path path = new Path(getTablature().getDisplay());
    	path.moveTo(x1,y1);    	
    	path.cubicTo( x1,y2 - ((y2 - y1) / 2), x2 - ((x2 - x1) / 2)  , y2,  x2,y2);
    	path.cubicTo( x2 + ((x3 - x2) / 2) , y2 , x3 , y3 + ((y2 - y3) / 2) ,x3,y3);    	    	
    	path.cubicTo(x3,y4 + ((y3 - y4) / 2),x4 + ((x3 - x4) / 2),y4 ,x4,y4);    	    	
    	path.cubicTo( x4 - ((x4 - x1) / 2), y4 , x1 , y1 - ((y1 - y4) / 2) ,x1,y1); 	    
    	    
    	//Creo la imagen
    	Image image = new Image(getTablature().getDisplay(),x + width,y + height);
        GC imageGC = new GC(image);                    
        if(full){
        	imageGC.setBackground(color);
        	imageGC.fillPath(path);
        }else{
        	imageGC.setForeground(color);    
        	imageGC.drawPath(path);
        }
        imageGC.dispose();
        
        //retorno la imagen con mascara
        ImageData src = image.getImageData();  
        ImageData mask = ImageUtils.applyMask(src,new RGB(0xFF,0xFF,0xFF),new RGB(0x00,0x00,0x00));                
        image.dispose();

        this.scoreNoteWidth = (int)(((float)(getScoreLineSpan() - 1) / (float)3) * 4);
        
        return new Image(getTablature().getDisplay(), src,mask);
    }	
    
	private Image makeArmonicImage(Color color,boolean full) {      
		int size = getScoreLineSpan();
		
	    int x = 0;
	    int y = 1;
	    int width = getScoreNoteWidth() - 1;
	    int height = size - 2;
		
	    int[] pointArray = new int[]{
	    		x ,(y + (height / 2)) ,(x + (width / 2)) ,(y + height),
	    		(x + (width / 2)) ,(y + height),(x + width) ,(y + (height / 2)),
	    		(x + width), (y + (height / 2)),  (x + (width / 2)) ,y,
	    		(x + (width / 2)) ,y, x , (y + (height / 2))
	    };
		
	    Image image = new Image(getTablature().getDisplay(),x + width + 2,y + height + 2);
        GC imageGC = new GC(image);              
        imageGC.setAdvanced(true);
        imageGC.setForeground(color);    
    	imageGC.drawPolygon(pointArray);        
        if(full){
        	imageGC.setBackground(color);        	
        	imageGC.fillPolygon(pointArray);
        }       
        ImageData src = image.getImageData();  
        ImageData mask = ImageUtils.applyMask(src,new RGB(0xFF,0xFF,0xFF),new RGB(0x00,0x00,0x00));        
        imageGC.dispose();
        image.dispose();
        
        return new Image(getTablature().getDisplay(), src,mask);
    }    	
	
    /**
     * Pinta las lineas
     */
    public void paintLines(SongTrackCoords trackCoords,TrackSpacing ts,GC gc,int x ,int y,int width) {    	    	     	    	
        if(width > 0){
        	x = (x < 0)?0:x;              	
        	setLineColor(gc);        	
        	                  	        	
        	//partitura
        	if(isScoreEnabled()){
        		int posY = y + ts.getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
        		for(int i = 1;i <= 5;i ++){
        			gc.drawLine(x, posY, x + width,posY);
        			posY += getScoreLineSpan();
        		}
        	}
        	//tablatura
        	if(isTablatureEnabled()){
        		y += ts.getPosition(TrackSpacing.POSITION_TABLATURE);
        		
        		Iterator it = trackCoords.getTrack().getStrings().iterator();
        		while(it.hasNext()){
        			InstrumentString string = (InstrumentString)it.next();
        			gc.drawLine(x, y, x + width, y);
        			y += getStringSpan();
        		}       
        	}
        }
    }            
    
    /**
     * Pinta el caret
     */
    public void paintCaret(GC gc) {    	
    	if(isCaretVisible() && (isTablatureEnabled() || isScoreEnabled())){
    		Caret caret = getTablature().getCaret();    
    		if(!caret.getMeasureCoords().isOutOfBounds()){
    			caret.paintCaret(this,gc);
    		}    		
        }
    }

    /**
     * Pinta el compas y las notas que estan sonando
     */    
    public void paintCacheMode(GC gc,MeasureCoords measure,List components,boolean paintMeasure,boolean playModeEnabled){
    	this.playModeEnabled = playModeEnabled;    	    	    	
    	//pinto el compas
    	if(paintMeasure){
    		measure.paintMeasure(this,gc,null);
    	}
    	//pinto las notas
    	setNoteStyle(gc);    	
    	Iterator it = components.iterator();
    	while(it.hasNext()){
    		MeasureComponent component = (MeasureComponent)it.next();
    		component.paint(this,gc,measure.getPosX()  + MeasureHeaderGui.DEFAULT_LEFT_SPAN, measure.getPosY());
    	}
    	//pinto los lyrics
    	measure.getTrackCoords().getLyricPainter().paintCurrentNoteBeats(gc,this,measure,measure.getPosX(), measure.getPosY());
    	
    	this.playModeEnabled = false;
    }    
    
    
    protected void checkTopSpan(TrackSpacing ts){    	
    	if(isScoreEnabled() && ts.getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES) <  DEFAULT_MIN_TOP_SPAN){
    		ts.setSize(TrackSpacing.POSITION_TOP, (DEFAULT_MIN_TOP_SPAN - ts.getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES)));
    	}else if(isTablatureEnabled() && ts.getPosition(TrackSpacing.POSITION_TABLATURE) < DEFAULT_MIN_TOP_SPAN){
    		ts.setSize(TrackSpacing.POSITION_TOP, (DEFAULT_MIN_TOP_SPAN - ts.getPosition(TrackSpacing.POSITION_TABLATURE)));
    	}
    }
    
    /**
     * Calcula el espacio minimo entre negras, dependiendo de la duracion de la nota 
     */
    public int getSpanForQuarter(Duration duration){        
        double span = ((double)Duration.QUARTER_TIME / (double)duration.getTime()) * getMinSpan(duration);
        return  (int)span;
    }   
    
    /**
     * Calcula el Espacio minimo que quedara entre nota y nota
     */
    private int getMinSpan(Duration duration){
        int minSpan = 0;
        switch(duration.getValue()){
        	case Duration.WHOLE:
        	    minSpan = 50;
        	    break;
        	case Duration.HALF:
        	    minSpan = 30;
        	    break;
        	case Duration.QUARTER:
        	    minSpan = 25;
        	    break;
        	case Duration.EIGHTH:
        	    minSpan = 20;
        	    break;       
        	default:
        	    minSpan = 18;
        	    break;
        }        
        return minSpan;        
    }        
    
    public boolean isCaretVisible(){
    	return true;
    }

    public boolean isPlayModeEnabled(){
    	return playModeEnabled;
    }
    
    public void setDefaultStyle(GC gc){
    	gc.setFont(tablature.getDefaultFont());
    }
    
    public void setNoteStyle(GC gc){
    	gc.setFont(tablature.getNoteFont());    	
    }

    public void setGraceStyle(GC gc){
    	gc.setFont(tablature.getGraceFont());
    }    
    
    public void setLyricStyle(GC gc){
    	gc.setFont(tablature.getLyricFont());    	
    }
    
    public void setTimeSignatureStyle(GC gc){
    	gc.setFont(tablature.getTimeSignatureFont());    	
    }

    public void setLineColor(GC gc){
    	gc.setForeground(tablature.getLineColor());    	
    }       
    
    public void setScoreNoteColor(GC gc){
    	gc.setForeground(tablature.getScoreNoteColor());    	
    }        
    
    public void setTabNoteColor(GC gc){
    	gc.setForeground(tablature.getTabNoteColor());    	
    }    

    public void setPlayNoteColor(GC gc){
    	gc.setForeground(tablature.getPlayNoteColor());    	
    }        

    public void setOfflineEffectStyle(GC gc){    	
    	gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));    	
    	gc.setFont(tablature.getDefaultFont());
    } 

    public void setTupletoStyle(GC gc){    	
    	gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));    	
    	gc.setFont(tablature.getDefaultFont());
    } 
    
    public Rectangle getNoteOrientation(GC gc,int x,int y,Note note){
    	String noteAsString = null;    	    	
    	if (note.isTiedNote()){
    		noteAsString = "L";
    		noteAsString = (note.getEffect().isGhostNote())?"(" + noteAsString + ")":noteAsString;
    	}else if(note.getEffect().isDeadNote()){
    		noteAsString = "X";
    		noteAsString = (note.getEffect().isGhostNote())?"(" + noteAsString + ")":noteAsString;
    	}else{
    		noteAsString = Integer.toString(note.getValue());
    		noteAsString = (note.getEffect().isGhostNote())?"(" + noteAsString + ")":noteAsString;
    	}
        return getOrientation(gc,x,y,noteAsString);        
    }
    
    public Rectangle getOrientation(GC gc,int x,int y,String s){    	
    	Point point = gc.stringExtent(s);    	
        return new Rectangle((x - (point.x / 2)),(y - (point.y / 2)),point.x, point.y );        
    }    
    
    protected boolean isMultiTrack(){
        return true;
    }

    protected int getTrackCount(){
        if(multitrack){
            return songManager.getSong().getTracks().size();
        }
        return 1;
    }           

    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public Tablature getTablature() {
        return tablature;
    }
    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
    
    
    public boolean isMultitrack() {
        return multitrack;
    }
    public void setMultitrack(boolean multitrack) {
        this.multitrack = multitrack;
    }

	public boolean isScoreEnabled() {
		return scoreEnabled;
	}

	public void setScoreEnabled(boolean scoreEnabled) {
		this.scoreEnabled = scoreEnabled;
	}
	
	public boolean isTablatureEnabled() {
		return tablatureEnabled;
	}

	public void setTablatureEnabled(boolean tablatureEnabled) {
		this.tablatureEnabled = tablatureEnabled;
	}

    public int getStringSpan(){
    	return DEFAULT_STRING_SPAN;
    }
        
    public int getScoreLineSpan(){
    	return DEFAULT_SCORE_LINE_SPAN;
    }    
    
    private int getScoreSpan(){
    	return scoreSpan;
    }  
    public void setScoreSpan(int scoreSpan){
    	this.scoreSpan = scoreSpan;
    }    
    
    public int getDefaultTrackSpan(){
    	return DEFAULT_TRACK_SPAN;
    }

    public int getMinScoreTabSpan(){
    	return MIN_SCORE_TAB_SPAN;
    }    
    
    public int getDefaultEffectSpan(){
    	return DEFAULT_EFFECT_SPAN;
    }
    
    public int getDefaultFirstTrackSpan(){
    	return DEFAULT_FIRST_TRACK_SPAN;
    }

    public boolean isFirstMeasure(Measure measure){
    	return (measure.getNumber() == 1);
    }
        
    public boolean isLastMeasure(Measure measure){
    	return (measure.getNumber() == getSongManager().countMeasures());
    }
        
    protected void clearTrackPositions(){
    	this.trackPositions.clear();
    }
    
    protected void addTrackPosition(int track,int posY,int height){
    	this.trackPositions.add(new TrackPosition(track,posY,height));
    }
    
    public int getTrackNumberAt(List tracksCoords,int y/*,int vScroll*/){
    	TrackPosition trackPos = getTrackPositionAt(y/*, vScroll*/);
    	return ((trackPos != null)?trackPos.getTrack():-1);
    }      
    
    public TrackPosition getTrackPositionAt(int y/*,int vScroll*/){
    	TrackPosition trackPos = null;               
        int minorDistance = 0;

        Iterator it = trackPositions.iterator();
        while(it.hasNext()){
        	TrackPosition pos = (TrackPosition)it.next();        	
            int distanceY = Math.min(Math.abs(y - (pos.getPosY())), Math.abs(y - (pos.getPosY() + pos.getHeight() - 10)));
            if(trackPos == null || distanceY < minorDistance){
            	trackPos = pos;
                minorDistance = distanceY;
            }
        }        
            
        return trackPos;    
    }        
    
    public void disposeLayout(){    	
    	this.disposeTracks();
    	this.disposeScoreNotes();
    }    
    
    protected void disposeScoreNotes(){
    	if(this.scoreNotes != null){
    		for(int i = 0; i < this.scoreNotes.length; i++){
    			this.scoreNotes[i].dispose();
    		}
    	}
    }  
    
    protected void disposeHarmonicNotes(){
    	if(this.harmonicNotes != null){
    		for(int i = 0; i < this.harmonicNotes.length; i++){
    			this.harmonicNotes[i].dispose();
    		}
    	}
    }    
    
    protected void disposeTracks(){
    	getTablature().getSongCoords().disposeTracks();
    }    
    
    public class TrackPosition{
    	private int track;
    	private int posY;
    	private int height;
    	
    	public TrackPosition(int track,int posY,int height){
    		this.track = track;
    		this.posY = posY;
    		this.height = height;
    	}

		public int getPosY() {
			return posY;
		}
		
		public int getHeight() {
			return height;
		}
		
		public int getTrack() {
			return track;
		}    	
    }    
    
}
