/*
 * Created on 02-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.herac.tuxguitar.song.models.Chord;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChordSelector extends Composite{
    private ChordEditor editor;
    private ChordList list;
    private int[] tunning;
    private List tonicList;
    private List chordList;
    private List alterationList;    
    
    public ChordSelector(Composite parent,int style) {        
        super(parent,style);
        this.setLayout(new GridLayout(2,false));
        this.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        this.init();
    }

    
    public void init(){
    	Composite leftComposite = new Composite(this,SWT.NONE);
    	Composite rightComposite = new Composite(this,SWT.NONE);
    	leftComposite.setLayout(new GridLayout());
    	rightComposite.setLayout(new GridLayout());
    	
    	leftComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
    	rightComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
    	
    	this.tonicList = new List(leftComposite,SWT.BORDER);
    	this.tonicList.setLayoutData(makeGridData());
        String[] tonicNames = getTonicNames();
        for(int i = 0;i < tonicNames.length;i++){
            this.tonicList.add(tonicNames[i]);
        }
        this.tonicList.setSelection(0);
               
        this.chordList = new List(rightComposite,SWT.BORDER);
        this.chordList.setLayoutData(makeGridData());
        String[] chordNames = getChordNames();
        for(int i = 0;i < chordNames.length;i++){
            this.chordList.add(chordNames[i]);
        }        
        this.chordList.setSelection(0);
        
        this.alterationList = new List(rightComposite,SWT.BORDER);
        this.alterationList.setLayoutData(makeGridData());
        String[] alterationNames = getAlterationNames();
        for(int i = 0;i < alterationNames.length;i++){
            this.alterationList.add(alterationNames[i]);
        }        
        this.alterationList.setSelection(0);        
        
        this.tonicList.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                if(editor != null && list != null){                 
                    showChord(tonicList.getSelectionIndex() + 1,chordList.getSelectionIndex() + 1,alterationList.getSelectionIndex() + 1);
                    list.redraw();
                }
            }
        });  
        
        this.chordList.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                if(editor != null && list != null){                 
                    showChord(tonicList.getSelectionIndex() + 1,chordList.getSelectionIndex() + 1,alterationList.getSelectionIndex() + 1);
                    list.redraw();
                }
            }
        });         
        
        this.alterationList.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                if(editor != null && list != null){                 
                    showChord(tonicList.getSelectionIndex() + 1,chordList.getSelectionIndex() + 1,alterationList.getSelectionIndex() + 1);
                    list.redraw();
                }
            }
        });           
    }
    
    private GridData makeGridData(){
    	GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);
    	data.minimumWidth = 50;
    	
    	return data;
    }
    
    public void setEditor(ChordEditor editor){
        this.editor = editor;
    }
    
    public void setList(ChordList list){
        this.list = list;
    }    
    
    public void setTunning(int[] tunning){
        this.tunning = tunning;
    }
    
    private String[] getTonicNames(){
        String[] names = new String[12];
     
        names[0] = "C";
        names[1] = "C#";
        names[2] = "D";
        names[3] = "D#";
        names[4] = "E";
        names[5] = "F";
        names[6] = "F#";
        names[7] = "G";
        names[8] = "G#";
        names[9] = "A";
        names[10] = "A#";
        names[11] = "B";
        
        return names;
    }
    
    private String[] getChordNames(){
        String[] names = new String[4];
     
        names[0] = "M";
        names[1] = "m";
        names[2] = "sus2";
        names[3] = "sus4";
        
        return names;
    }    

    private String[] getAlterationNames(){
        String[] names = new String[5];
     
        names[0] = "Normal";
        names[1] = "7";
        names[2] = "7M";
        names[3] = "6";
        names[4] = "5";
        
        return names;
    }  
    
    private void showChord(int tonic,int chordType,int alterationType){
        int requiredNotes[] = getRequiredNotes(chordType,alterationType);
        
        //entre cegillas 1 y 4
        int fret1 = 0;
        int fret2 = 3;

        java.util.List chords = new ArrayList();
        ChordCreatorUtil chordCreator = null;
        for(int i = 0;i < 10;i++){
            chordCreator = new ChordCreatorUtil(this.tunning,requiredNotes,tonic,fret1 + i,fret2 + i);
            Chord chord = chordCreator.getChord();
            if(chord != null){
                chords.add(chord);
            }
        }
        this.list.setChords(chords);
    }

    private int[] getRequiredNotes(int chordType,int alterationType){               
        int requiredNotes[] = null;
        
        int alterationRequired = getAlterationRequired(alterationType);
        int moveLength = (alterationRequired > 0)?1:0;
        
        switch(chordType){
        	case 1:        	    
        	    requiredNotes = new int[3 + moveLength]; 
        	    requiredNotes[0 + moveLength] = 1;
        	    requiredNotes[1 + moveLength] = 5;
        	    requiredNotes[2 + moveLength] = 8;
        	    break;
        	case 2:
        	    requiredNotes = new int[3 + moveLength]; 
        	    requiredNotes[0 + moveLength] = 1;
        	    requiredNotes[1 + moveLength] = 4;
        	    requiredNotes[2 + moveLength] = 8;
        	    break;
        	case 3:
        	    requiredNotes = new int[4 + moveLength]; 
        	    requiredNotes[0 + moveLength] = 3;
        	    requiredNotes[1 + moveLength] = 1;
        	    requiredNotes[2 + moveLength] = 5;
        	    requiredNotes[3 + moveLength] = 8;
        	    break;
        	case 4:
        	    requiredNotes = new int[4 + moveLength]; 
        	    requiredNotes[0 + moveLength] = 6;
        	    requiredNotes[1 + moveLength] = 1;
        	    requiredNotes[2 + moveLength] = 8;
        	    requiredNotes[3 + moveLength] = 5;
        	    break;        	    
        }
        if(alterationRequired > 0){
            requiredNotes[0] = alterationRequired;
        }
        
        return requiredNotes;
    }
    
    private int getAlterationRequired(int alterationType){
        int requiredNote = 0;
        
        switch(alterationType){
    	case 1:
    	    requiredNote = 0;
    	    break;
    	case 2:
    	    requiredNote = 11;
    	    break;
    	case 3:
    	    requiredNote = 12;
    	    break;    	    
    	case 4:
    	    requiredNote = 10;
    	    break;
    	case 5:
    	    requiredNote = 8;
    	    break;    	    
        }       
        return requiredNote;
    }    
}
