/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SetAccessibleAction;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;

public abstract class ClientBaseDataSource
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -7660172643035173692L;
    protected int loginTimeout = 0;
    public static final String propertyKey_loginTimeout = "loginTimeout";
    public static final int propertyDefault_loginTimeout = 0;
    protected transient PrintWriter logWriter = null;
    protected String databaseName = null;
    public static final String propertyKey_databaseName = "databaseName";
    protected String description = null;
    public static final String propertyKey_description = "description";
    protected String dataSourceName = null;
    public static final String propertyKey_dataSourceName = "dataSourceName";
    protected int portNumber = 1527;
    public static final int propertyDefault_portNumber = 1527;
    public static final String propertyKey_portNumber = "portNumber";
    protected String serverName = "localhost";
    public static final String propertyDefault_serverName = "localhost";
    public static final String propertyKey_serverName = "serverName";
    protected String user = "APP";
    public static final String propertyKey_user = "user";
    public static final String propertyDefault_user = "APP";
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    public static final int NOT_SET = 0;
    public static final int YES = 1;
    public static final int NO = 2;
    protected short securityMechanism = (short)4;
    public static final short propertyDefault_securityMechanism = 4;
    public static final String propertyKey_securityMechanism = "securityMechanism";
    protected boolean retrieveMessageText = true;
    public static final boolean propertyDefault_retrieveMessageText = true;
    public static final String propertyKey_retrieveMessageText = "retrieveMessageText";
    protected String traceFile = null;
    public static final String propertyKey_traceFile = "traceFile";
    private transient int traceFileSuffixIndex_ = 0;
    protected String traceDirectory = null;
    public static final String propertyKey_traceDirectory = "traceDirectory";
    protected boolean traceFileAppend = false;
    public static final boolean propertyDefault_traceFileAppend = false;
    public static final String propertyKey_traceFileAppend = "traceFileAppend";
    public static final String propertyKey_password = "password";
    protected String password = null;
    public static final short USER_ONLY_SECURITY = 4;
    public static final short CLEAR_TEXT_PASSWORD_SECURITY = 3;
    public static final short ENCRYPTED_PASSWORD_SECURITY = 7;
    public static final short ENCRYPTED_USER_AND_PASSWORD_SECURITY = 9;
    protected String connectionAttributes = null;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_CONNECTION_CALLS = 1;
    public static final int TRACE_STATEMENT_CALLS = 2;
    public static final int TRACE_RESULT_SET_CALLS = 4;
    public static final int TRACE_DRIVER_CONFIGURATION = 16;
    public static final int TRACE_CONNECTS = 32;
    public static final int TRACE_PROTOCOL_FLOWS = 64;
    public static final int TRACE_RESULT_SET_META_DATA = 128;
    public static final int TRACE_PARAMETER_META_DATA = 256;
    public static final int TRACE_DIAGNOSTICS = 512;
    public static final int TRACE_XA_CALLS = 2048;
    public static final int TRACE_ALL = -1;
    public static final int propertyDefault_traceLevel = -1;
    public static final String propertyKey_traceLevel = "traceLevel";
    protected int traceLevel = -1;
    static /* synthetic */ Class class$org$apache$derby$client$ClientDataSourceFactory;
    static /* synthetic */ Class class$java$lang$Object;

    protected ClientBaseDataSource() {
    }

    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static String getUser(Properties properties) {
        String string = properties.getProperty(propertyKey_user);
        return ClientBaseDataSource.parseString(string, propertyDefault_user);
    }

    public static short getSecurityMechanism(Properties properties) {
        String string = properties.getProperty(propertyKey_securityMechanism);
        String string2 = properties.getProperty(propertyKey_password);
        short s = ClientBaseDataSource.parseShort(string, (short)4);
        return ClientBaseDataSource.getUpgradedSecurityMechanism(s, string2);
    }

    public static short getUpgradedSecurityMechanism(short s, String string) {
        if (string != null && s == 4) {
            return 3;
        }
        return s;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String string = properties.getProperty(propertyKey_retrieveMessageText);
        return ClientBaseDataSource.parseBoolean(string, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty(propertyKey_traceFile);
    }

    public static String getTraceDirectory(Properties properties) {
        return properties.getProperty(propertyKey_traceDirectory);
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String string = properties.getProperty(propertyKey_traceFileAppend);
        return ClientBaseDataSource.parseBoolean(string, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty(propertyKey_password);
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), (class$org$apache$derby$client$ClientDataSourceFactory == null ? (class$org$apache$derby$client$ClientDataSourceFactory = ClientBaseDataSource.class$("org.apache.derby.client.ClientDataSourceFactory")) : class$org$apache$derby$client$ClientDataSourceFactory).getName(), null);
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.startsWith("propertyKey_") || Modifier.isTransient(fieldArray[i].getModifiers())) continue;
            try {
                Field field;
                String string2 = fieldArray[i].get(this).toString();
                clazz = this.getClass();
                while (true) {
                    try {
                        field = clazz.getDeclaredField(string.substring(12));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? ClientBaseDataSource.class$("java.lang.Object") : class$java$lang$Object)) continue;
                        throw new NamingException("bug check: corresponding property field does not exist");
                    }
                    break;
                }
                if (Modifier.isTransient(field.getModifiers())) continue;
                AccessController.doPrivileged(new SetAccessibleAction(field, true));
                Object object = field.get(this);
                String string3 = object == null ? null : String.valueOf(object);
                reference.add(new StringRefAddr(string2, string3));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NamingException("bug check: property cannot be accessed");
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new NamingException("Privileged action exception occurred.");
            }
        }
        return reference;
    }

    public void hydrateFromReference(Reference reference) throws SQLException {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.startsWith("propertyKey_") || Modifier.isTransient(fieldArray[i].getModifiers())) continue;
            try {
                RefAddr refAddr;
                Field field;
                String string2 = fieldArray[i].get(this).toString();
                clazz = this.getClass();
                while (true) {
                    try {
                        field = clazz.getDeclaredField(string.substring(12));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? ClientBaseDataSource.class$("java.lang.Object") : class$java$lang$Object)) continue;
                        throw new SqlException(new LogWriter(this.logWriter, this.traceLevel), "bug check: corresponding property field does not exist");
                    }
                    break;
                }
                if (Modifier.isTransient(field.getModifiers()) || (refAddr = reference.get(string2)) == null) continue;
                field.setAccessible(true);
                String string3 = field.getType().toString();
                if (string3.equals("boolean")) {
                    boolean bl = ((String)refAddr.getContent()).equalsIgnoreCase("true");
                    field.setBoolean(this, bl);
                    continue;
                }
                if (string3.equals("byte")) {
                    byte by = Byte.parseByte((String)refAddr.getContent());
                    field.setByte(this, by);
                    continue;
                }
                if (string3.equals("short")) {
                    short s = Short.parseShort((String)refAddr.getContent());
                    field.setShort(this, s);
                    continue;
                }
                if (string3.equals("int")) {
                    int n = Integer.parseInt((String)refAddr.getContent());
                    field.setInt(this, n);
                    continue;
                }
                if (string3.equals("long")) {
                    long l = Long.parseLong((String)refAddr.getContent());
                    field.setLong(this, l);
                    continue;
                }
                if (string3.equals("float")) {
                    float f = Float.parseFloat((String)refAddr.getContent());
                    field.setFloat(this, f);
                    continue;
                }
                if (string3.equals("double")) {
                    double d = Double.parseDouble((String)refAddr.getContent());
                    field.setDouble(this, d);
                    continue;
                }
                if (string3.equals("char")) {
                    char c = ((String)refAddr.getContent()).charAt(0);
                    field.setChar(this, c);
                    continue;
                }
                field.set(this, refAddr.getContent());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SqlException(new LogWriter(this.logWriter, this.traceLevel), "bug check: property cannot be accessed");
            }
        }
    }

    public Properties getProperties() throws SQLException {
        Properties properties = new Properties();
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.startsWith("propertyKey_") || Modifier.isTransient(fieldArray[i].getModifiers())) continue;
            try {
                Field field;
                String string2 = fieldArray[i].get(this).toString();
                clazz = this.getClass();
                while (true) {
                    try {
                        field = clazz.getDeclaredField(string.substring(12));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? ClientBaseDataSource.class$("java.lang.Object") : class$java$lang$Object)) continue;
                        throw new SqlException(new LogWriter(this.logWriter, this.traceLevel), "bug check: corresponding property field does not exist");
                    }
                    break;
                }
                if (Modifier.isTransient(field.getModifiers())) continue;
                field.setAccessible(true);
                Object object = field.get(this);
                String string3 = String.valueOf(object);
                if (propertyKey_password.equals(string2)) {
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    for (int j = 0; j < string3.length(); ++j) {
                        stringBuffer.setCharAt(j, '*');
                    }
                    string3 = stringBuffer.toString();
                }
                properties.setProperty(string2, string3);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SqlException(new LogWriter(this.logWriter, this.traceLevel), "bug check: property cannot be accessed");
            }
        }
        return properties;
    }

    public LogWriter computeDncLogWriterForNewConnection(String string) throws SqlException {
        return ClientBaseDataSource.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, string, this.traceFileSuffixIndex_++);
    }

    public static LogWriter computeDncLogWriterForNewConnection(PrintWriter printWriter, String string, String string2, boolean bl, int n, String string3, int n2) throws SqlException {
        int n3 = Configuration.traceFileSuffixIndex__++;
        LogWriter logWriter = ClientBaseDataSource.computeDncLogWriter(printWriter, string, string2, bl, string3, n2, n);
        if (logWriter != null) {
            return logWriter;
        }
        logWriter = ClientBaseDataSource.computeDncLogWriter(null, Configuration.traceDirectory__, Configuration.traceFile__, Configuration.traceFileAppend__, "_global", n3, Configuration.traceLevel__);
        return logWriter;
    }

    static LogWriter computeDncLogWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSource.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        NetLogWriter netLogWriter = new NetLogWriter(printWriter2, n2);
        if (printWriter2 != printWriter && string != null) {
            netLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return netLogWriter;
    }

    public static LogWriter computeDncLogWriter(Connection connection, PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSource.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        LogWriter logWriter = connection.agent_.newLogWriter_(printWriter2, n2);
        if (printWriter2 != printWriter && string != null) {
            logWriter.printWriterNeedsToBeClosed_ = true;
        }
        return logWriter;
    }

    static PrintWriter computePrintWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n) throws SqlException {
        if (printWriter != null) {
            return printWriter;
        }
        if (string != null) {
            String string4 = string2 == null ? string + "/" + string3 + "_" + n : string + "/" + string2 + string3 + "_" + n;
            return LogWriter.getPrintWriter(string4, true);
        }
        if (string2 != null) {
            return LogWriter.getPrintWriter(string2, bl);
        }
        return null;
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string != null) {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        return bl;
    }

    private static String parseString(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    private static short parseShort(String string, short s) {
        if (string != null) {
            return Short.parseShort(string);
        }
        return s;
    }

    private static int parseInt(String string, int n) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return n;
    }

    public static Properties tokenizeAttributes(String string, Properties properties) throws SqlException {
        if (string == null) {
            return properties;
        }
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new SqlException(null, "Invalid attribute syntax: " + string);
                }
                properties2.setProperty(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, noSuchElementException, "Invalid attribute syntax: " + string);
        }
        ClientBaseDataSource.checkBoolean(properties2, propertyKey_retrieveMessageText);
        return properties2;
    }

    private static void checkBoolean(Properties properties, String string) throws SqlException {
        String[] stringArray = new String[]{"true", "false"};
        ClientBaseDataSource.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SqlException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String string3 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string3 = string3 + "|";
            }
            string3 = string3 + stringArray[i];
        }
        throw new SqlException(null, "JDBC attribute " + string + "has an invalid value " + string2 + " Valid values are " + string3);
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setRetrieveMessageText(boolean bl) {
        this.retrieveMessageText = bl;
    }

    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    public synchronized void setSecurityMechanism(short s) {
        this.securityMechanism = s;
    }

    public short getSecurityMechanism() {
        return ClientBaseDataSource.getUpgradedSecurityMechanism(this.securityMechanism, this.password);
    }

    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String string = properties.getProperty(propertyKey_traceLevel);
        return ClientBaseDataSource.parseInt(string, -1);
    }

    public synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public synchronized void setTraceFile(String string) {
        this.traceFile = string;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public synchronized void setTraceDirectory(String string) {
        this.traceDirectory = string;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public synchronized void setTraceFileAppend(boolean bl) {
        this.traceFileAppend = bl;
    }

    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    protected void updateDataSourceValues(Properties properties) {
        if (properties == null) {
            return;
        }
        if (properties.containsKey(propertyKey_user)) {
            this.setUser(ClientBaseDataSource.getUser(properties));
        }
        if (properties.containsKey(propertyKey_securityMechanism)) {
            this.setSecurityMechanism(ClientBaseDataSource.getSecurityMechanism(properties));
        }
        if (properties.containsKey(propertyKey_traceFile)) {
            this.setTraceFile(ClientBaseDataSource.getTraceFile(properties));
        }
        if (properties.containsKey(propertyKey_traceDirectory)) {
            this.setTraceDirectory(ClientBaseDataSource.getTraceDirectory(properties));
        }
        if (properties.containsKey(propertyKey_traceFileAppend)) {
            this.setTraceFileAppend(ClientBaseDataSource.getTraceFileAppend(properties));
        }
        if (properties.containsKey(propertyKey_securityMechanism)) {
            this.setSecurityMechanism(ClientBaseDataSource.getSecurityMechanism(properties));
        }
        if (properties.containsKey(propertyKey_retrieveMessageText)) {
            this.setRetrieveMessageText(ClientBaseDataSource.getRetrieveMessageText(properties));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

