import gtk
import gobject
import sys
import re
import string

#Skype4Py
import Skype4Py

# for debugging
import pdb

REV="$Rev: 140 $"

class RegisterPhone:

	def __init__(self, skype_obj):
		# Initialize vars
		self.mysms = False
		self.mysms1 = False

		self.skype = skype_obj
		self.skype.RegisterEventHandler('SmsTargetStatusChanged', self.SmsTargetStatusChanged)

	def SmsTargetStatusChanged(self, target, status):
		if not self.mysms1:
			return

		if self.mysms1 == target.Message:
			sms = target.Message
			gtk.gdk.threads_enter()
			if sms.Targets[0].Status == "TARGET_DELIVERY_SUCCESSFUL":
				self.code_status.set_text('Status: Registered')
			else:
				self.code_status.set_text('Status: %s' %  sms.FailureReason)
			gtk.gdk.threads_leave()

	def get_code(self, widget, entry):
		number = entry.get_text()
		if number == "":
			return
		self.mysms = self.skype.CreateSms('CONFIRMATION_CODE_REQUEST', number)
		self.mysms.Send()
		self.set_code_phone.set_text(self.get_code_phone.get_text())
		self.code.grab_focus()

	def set_code(self, widget):
		number = self.set_code_phone.get_text()
		code = self.code.get_text()
		if code == "" or number == "":
			return

		self.mysms1 = self.skype.CreateSms('CONFIRMATION_CODE_SUBMIT', number)
		self.mysms1.Body = code
		self.mysms1.Send()

	def clear_all(self, widget):
		self.mysms = False
		self.mysms1 = False

		# Reset SMS
		self.get_code_phone.set_text('')
		self.set_code_phone.set_text('')
		self.code.set_text('')

		self.get_code_phone.grab_focus()

	def window_register_phone(self):
		vbox = gtk.VBox(False, 0)

		label = gtk.Label("Register Phone")
		label.set_markup("<span size=\"large\" weight=\"bold\">Register Phone</span>") 

		vbox.pack_start(label, False, False, 0)
		label.show()

		label = gtk.Label("Currently registered Phone:")
		label.set_justify(gtk.JUSTIFY_LEFT)
		vbox.pack_start(label, False, False, 0)
		label.show()

		if len(self.skype.CurrentUserProfile.ValidatedSmsNumbers) > 0:
		    s = self.skype.CurrentUserProfile.ValidatedSmsNumbers[0]
		else:
		    s = ""
		label = gtk.Label(s)
		label.set_justify(gtk.JUSTIFY_LEFT)
		vbox.pack_start(label, False, False, 0)
		label.show()

		frame = gtk.Frame('Get Registration Code:')
		vbox0 = gtk.VBox(False, 0)
		hbox = gtk.HBox(False, 0)

		label = gtk.Label('Phone #:')
		hbox.pack_start(label, False, False, 0)
		label.show()

		self.get_code_phone = gtk.Entry()
		self.get_code_phone.set_max_length(100)
		self.get_code_phone.set_width_chars(25)
		self.get_code_phone.connect("activate", self.get_code, self.get_code_phone)
		hbox.pack_start(self.get_code_phone, False, False, 0)
		self.get_code_phone.show()
		self.get_code_phone.grab_focus()

		vbox0.pack_start(hbox, False, False, 0)
		hbox.show()


		self.sendbutton = gtk.Button("Get it!")
		self.sendbutton_connect = self.sendbutton.connect("clicked",
			self.get_code, self.get_code_phone)
		self.sendbutton.set_flags(gtk.CAN_DEFAULT)
		vbox0.pack_start(self.sendbutton, False, False, 0)
		self.sendbutton.show()

		vbox0.show()
		frame.add(vbox0)
		frame.show()
		vbox.pack_start(frame, False, False, 0)

		frame1 = gtk.Frame('Register Phone with Code:')
		vbox1 = gtk.VBox(False, 0)

		hbox1 = gtk.HBox(False, 0)
		label1 = gtk.Label('Phone #:')
		hbox1.pack_start(label1, False, False, 0)
		label1.show()

		self.set_code_phone = gtk.Entry()
		self.set_code_phone.set_max_length(100)
		self.set_code_phone.set_width_chars(25)
		self.set_code_phone.connect("activate", self.set_code)
		hbox1.pack_start(self.set_code_phone, False, False, 0)
		self.set_code_phone.show()
		self.set_code_phone.grab_focus()

		vbox1.pack_start(hbox1, False, False, 0)
		hbox1.show()

		hbox2 = gtk.HBox(False, 0)
		label2 = gtk.Label('Code:')
		hbox2.pack_start(label2, False, False, 0)
		label2.show()

		self.code = gtk.Entry()
		self.code.set_max_length(100)
		self.code.set_width_chars(25)
		self.code.connect("activate", self.set_code)
		self.code.show()

		hbox2.pack_start(self.code, False, False, 0)
		hbox2.show()

		vbox1.pack_start(hbox2, False, False, 0)

		self.sendbutton1 = gtk.Button("Set it!")
		self.sendbutton1_connect = self.sendbutton1.connect("clicked",
			self.set_code)
		self.sendbutton1.show()
		vbox1.pack_start(self.sendbutton1, False, False, 0)

		self.code_status = gtk.Label()
		vbox1.pack_start(self.code_status)
		self.code_status.show()

		vbox1.show()
		frame1.add(vbox1)
		frame1.show()
		vbox.pack_start(frame1, True, True, 5)

		self.sendbutton2 = gtk.Button("Clear Up!")
		self.sendbutton2_connect = self.sendbutton2.connect("clicked",
			self.clear_all)
		self.sendbutton2.show()
		vbox.pack_start(self.sendbutton2, False, False, 0)

		# Now show everything
		vbox.show()
		return vbox


