from string import *
from math import *

#######################################
##
## Subroutines for Corwin's Self Abs Corrections
##
######################################

## these routines correspond to the atomic_sub.F routines

## FUNCTION sym2Z
## USAGE:
##	Z=sym2Z(sym)
##
##	given two chacacter sym, returns Z (atomic number).
##  Only has first 103 elements of periodic table.
##	Returns -1 if element not found
##
##

def sym2Z(sym):
    esym=[  "H" , "He", "Li", "Be", "B" , "C" , "N" , "O" , "F" , "Ne", "Na",
        "Mg", "Al", "Si", "P" , "S" , "Cl", "Ar", "K" , "Ca", "Sc", "Ti",
        "V" , "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As",
        "Se", "Br", "Kr", "Rb", "Sr", "Y" , "Zr", "Nb", "Mo", "Tc", "Ru",
        "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I" , "Xe", "Cs",
        "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy",
        "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W" , "Re", "Os", "Ir",
        "Pt", "Au", "Hd", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra",
        "Ac", "Th", "Pa", "U" , "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es",
        "Fm", "Md", "No", "Lw"]
    if len(sym)>1 and sym[1]==' ':
        sym=sym[0]
    try:
        i=esym.index(sym)
        i=i+1
    except:
        i=-1
    return i

## FUNCTION Z2sym
## USAGE:
##   sym=Z2sym(Z)
##
##	 given two chacacter sym, returns Z (atomic number).
##   Only has first 103 elements of periodic table.
##	 Returns -1 if element not found

def Z2sym(Z):
    esym=[  "H" , "He", "Li", "Be", "B" , "C" , "N" , "O" , "F" , "Ne", "Na",
        "Mg", "Al", "Si", "P" , "S" , "Cl", "Ar", "K" , "Ca", "Sc", "Ti",
        "V" , "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As",
        "Se", "Br", "Kr", "Rb", "Sr", "Y" , "Zr", "Nb", "Mo", "Tc", "Ru",
        "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I" , "Xe", "Cs",
        "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy",
        "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W" , "Re", "Os", "Ir",
        "Pt", "Au", "Hd", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra",
        "Ac", "Th", "Pa", "U" , "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es",
        "Fm", "Md", "No", "Lw"]
    if 1<=Z<104:
        Z=int(Z)
        i=esym[Z-1]
    else:
        i=-1
    return i

##  FUNCTION get_enot
##  USAGE:
##   e_not=get_e_not(Z,edge_code)
##   Given Z and edge, returns Eo.  Values for K-edge are from
##   Teo's "EXAFS: Basic Principles and Data Analysis."  Other
##   edges are from the X-Ray Data Book.
##   oxygen edge adjusted a la Corwin Booth

def get_e_not(Z,edge_code):
    K_e_not=[13.6,25,55,112,192,283,399,533.4,687,867,1072,
             1305,1559,1838,2142,2472,2822,3202,3607,4038,
             4496,4965,5465,5989,6540,7112,7709,8333,8979,
             9659,10368,11104,11868,12658,13474,14322,15201,
             16105,17037,17998,18986,20002,21054,22118,23224,
             24350,25514,26711,27940,29200,30491,31813,33169,
             34582,35959,37441,38925,40449,41998,43571,45207,
             46835,48515,50240,51996,53789,55615,57483,59390,
             61332,63304,65351,67414,69524,71662,73860,76112,
             78395,80723,83103,85528,88006,90527,93112,95740,
             98418,191147,103927,106759,109649,112581,115603,
             118619,121760,124876,128088,131357,134683]

    LI_e_not=[0,0,0,0,0,0,37.3,41.6,0,48.5,63.5,88.6,117.8,
              149.7,189,2309,270,326.3,378.6,438.4,498.0,
              560.9,626.7,695.7,769.1,844.6,925.1,1008.6,
              1096.7,1196.2,1299.0,1414.6,1527.0,1652.0,
              1782,1921,2065,2216,2373,2532,2698,2866,3043,
              3224,3412,3604,3806,4018,4238,4465,4698,4939,
              5188,5453,5714,5989,6266,6548,6835,7126,7428,
              7737,8052,7376,7808,9046,9394,9751,10116,
              10486,10870,11271,11682,12100,12527,12968,13419,
              13880,14353,14839,15347,15861,16388,16939,17493,
              18049,18639,19237,19840,20472,21105,21757,0,0,0,
              0,0,0]

    LII_e_not=[0,0,0,0,0,0,0,0,0,21.7,30.4,49.6,72.9,99.8,136,
               163.6,202,250.6,297.6,349.7,403.6,461.2,519.8,
               583.8,649.9,719.9,793.3,870.0,952.3,1044.9,1143.2,
               1248.1,1359.1,1474.3,1596,1730.9,1864,2007,2156,
               2307,2465,2625,2793,2967,3146,3330,3524,3727,3938,
               4156,4380,4612,4852,5104,5359,5624,5891,6164,6440,
               6722,7013,7312,7617,7930,8252,8581,8918,9264,9617,
               9978,10349,10739,11136,11544,11959,12385,12824,
               13273,13734,14209,14698,15200,15711,16244,16785,
               17337,17907,18484,19083,19693,20314,20948,21625,22263.,0,0,
               0,0]

    LIII_e_not=[0,0,0,0,0,0,0,0,0,21.6,30.5,49.2,72.5,99.2,135,
                162.5,200,248.4,294.6,346.2,398.7,453.8,512.1,
                574.1,628.7,706.8,778.1,852.7,932.5,1021.8,1116.4,
                1217.0,1323.6,1433.9,1550,1678.4,1804,1940,2080,
                2223,2371,2520,2677,2838,3004,3173,3351,3538,3730,
                3929,4132,4341,4557,4782,5012,5247,5483,5723,5964,
                6208,6459,6716,6977,7243,7514,7790,8071,8358,8648,
                8944,9244,9561,9881,10207,10535,10871,11215,11564,
                11919,12284,12658,13055,13419,13814,14214,14619,
                15031,15444,15871,16300,16733,17166,17700,18053,0,0,0,0]
    if(Z<=98):
        if(edge_code==0):
            e_not=K_e_not[Z-1]
        if(edge_code==1):
            e_not=LI_e_not[Z-1]
        if(edge_code==2):
            e_not=LII_e_not[Z-1]
        if(edge_code==3):
            e_not=LIII_e_not[Z-1]
    return e_not

##  FUNCTION get_fl
##  USAGE:
##   energy=get_fl(Z,edge_code)
##   Given Z and edge, returns fluorescent energy.  

def get_fl(Z,edge_code):
    #data in keV from mucal 
    K_e=[0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.104100E+01,0.125400E+01,0.148700E+01,0.174000E+01,0.201500E+01,
         0.230800E+01,0.262200E+01,0.295700E+01,0.331300E+01,0.369100E+01,
         0.409000E+01,0.451000E+01,0.495200E+01,0.541400E+01,0.589800E+01,
         0.640300E+01,0.693000E+01,0.747700E+01,0.804700E+01,0.863800E+01,
         0.925100E+01,0.988500E+01,0.105430E+02,0.112210E+02,0.119230E+02,
         0.126480E+02,0.133940E+02,0.141640E+02,0.149570E+02,0.157740E+02,
         0.166140E+02,0.174780E+02,0.184100E+02,0.192780E+02,0.202140E+02,
         0.211750E+02,0.221620E+02,0.231720E+02,0.242070E+02,0.252700E+02,
         0.263570E+02,0.274710E+02,0.286100E+02,0.298020E+02,0.309700E+02,
         0.321910E+02,0.334400E+02,0.347170E+02,0.360230E+02,0.373590E+02,
         0.386490E+02,0.401240E+02,0.415290E+02,0.429830E+02,0.444700E+02,
         0.459850E+02,0.475280E+02,0.490990E+02,0.507300E+02,0.523600E+02,
         0.540630E+02,0.557570E+02,0.575240E+02,0.593100E+02,0.611310E+02,
         0.629910E+02,0.648860E+02,0.668200E+02,0.687790E+02,0.708210E+02,
         0.728600E+02,0.749570E+02,0.770970E+02,0.000000E+00,0.000000E+00,
         0.838000E+02,0.000000E+00,0.000000E+00,0.000000E+00,0.933340E+02,
         0.000000E+00,0.984280E+02,0.000000E+00,0.103653E+03]

    L_e=[0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
         0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.100900E+01,
         0.109600E+01,0.118600E+01,0.128200E+01,0.141900E+01,0.148000E+01,
         0.158700E+01,0.169400E+01,0.180600E+01,0.192200E+01,0.204200E+01,
         0.216600E+01,0.229300E+01,0.242400E+01,0.255800E+01,0.269600E+01,
         0.283800E+01,0.298400E+01,0.313300E+01,0.328700E+01,0.344400E+01,
         0.360500E+01,0.376900E+01,0.393700E+01,0.411100E+01,0.428600E+01,
         0.446700E+01,0.465100E+01,0.484000E+01,0.503400E+01,0.543100E+01,
         0.563600E+01,0.584600E+01,0.605900E+01,0.627500E+01,0.649500E+01,
         0.672000E+01,0.694800E+01,0.718100E+01,0.718100E+01,0.741400E+01,
         0.765400E+01,0.789800E+01,0.814500E+01,0.839600E+01,0.865100E+01,
         0.891000E+01,0.917300E+01,0.944100E+01,0.971100E+01,0.998700E+01,
         0.102660E+02,0.105490E+02,0.108360E+02,0.000000E+00,0.000000E+00,
         0.117240E+02,0.000000E+00,0.000000E+00,0.000000E+00,0.129660E+02,
         0.000000E+00,0.136130E+02,0.000000E+00,0.142790E+02]

    if(Z<=98):
        if(edge_code==0):
            energy=K_e[Z-1]*1000
        if(edge_code==1):
            energy=L_e[Z-1]*1000
        if(edge_code==2):
            energy=L_e[Z-1]*1000
        if(edge_code==3):
            energy=L_e[Z-1]*1000
    return energy


##  FUNCTION get_atomic
##  USAGE:
##   [Z,edge_code,e_not]=get_atomic(in_string)
##   given in_string, returns Z, e_not, and edge_code.
##   in_string should be in the format 'SS EEEE'
##   where SS is symbol and EEEE is edge
##   for example 'Mn K' or 'U LIII'

def get_atomic(in_string):
    Zsym=in_string[0:2]
    if(in_string[2:3]==' '):
    	edge_sym=in_string[3:]
    else:
        edge_sym=in_string[2:]
    Z=sym2Z(Zsym)
    edge_sym=rstrip(edge_sym)
    edge_sym=ljust(edge_sym,4)
    edge_code=-1
    if(edge_sym=='K   '):
        edge_code=0
    if(edge_sym=='LI  '):
        edge_code=1
    if(edge_sym=='LII '):
        edge_code=2
    if(edge_sym=='LIII'):
        edge_code=3

    e_not=get_e_not(Z,edge_code)
    return [Z,edge_code,e_not]

##  FUNCTION get_fluo_energy
##  USAGE:
##   energy=get_fluo_energy(in_string)
##   given in_string, returns Z, e_not, and edge_code.
##   in_string should be in the format 'SS EEEE'
##   where SS is symbol and EEEE is edge
##   for example 'Mn K' or 'U LIII'

def get_fluo_energy(in_string):
    Zsym=in_string[0:2]
    if(in_string[2:3]==' '):
    	edge_sym=in_string[3:]
    else:
        edge_sym=in_string[2:]
    Z=sym2Z(Zsym)
    edge_sym=rstrip(edge_sym)
    edge_sym=ljust(edge_sym,4)
    edge_code=-1
    if(edge_sym=='K   '):
        edge_code=0
    if(edge_sym=='LI  '):
        edge_code=1
    if(edge_sym=='LII '):
        edge_code=2
    if(edge_sym=='LIII'):
        edge_code=3

    energy=get_fl(Z,edge_code)
    return energy
