//============================================================
//
//	osinline.h - GNU C inline functions
//
//============================================================

#ifndef __OSINLINE__
#define __OSINLINE__

#include "eminline.h"


//============================================================
//	INLINE FUNCTIONS
//============================================================

#if defined(__i386__) || defined(__x86_64__)


INLINE void osd_yield_processor(void)
{
	__asm__ __volatile__ ( " rep ; nop ;" );
}


#if defined(__x86_64__)

//============================================================
//  osd_exchange64
//============================================================

ATTR_UNUSED
INLINE INT64 _osd_exchange64(INT64 volatile *ptr, INT64 exchange)
{
	register INT64 ret;
	__asm__ __volatile__ (
		" lock ; xchg %[exchange], %[ptr] ;"
		: [ptr]      "+m" (*ptr)
		, [ret]      "=r" (ret)
		: [exchange] "1"  (exchange)
	);
	return ret;
}
#define osd_exchange64 _osd_exchange64

#endif /* __x86_64__ */


#elif defined(__ppc__) || defined (__PPC__) || defined(__ppc64__) || defined(__PPC64__)


INLINE void osd_yield_processor(void)
{
	__asm__ __volatile__ ( " nop \n nop \n" );
}



#if defined(__ppc64__) || defined(__PPC64__)

//============================================================
//  osd_exchange64
//============================================================

ATTR_UNUSED
INLINE INT64 _osd_exchange64(INT64 volatile *ptr, INT64 exchange)
{
	register INT64 ret;
	__asm__ __volatile__ (
		"1: ldarx  %[ret], 0, %[ptr]      \n"
		"   stdcx. %[exchange], 0, %[ptr] \n"
		"   bne--  1b                     \n"
		: [ret]      "=&r" (ret)
		: [ptr]      "r"   (ptr)
		, [exchange] "r"   (exchange)
		: "cr0"
	);
	return ret;
}
#define osd_exchange64 _osd_exchange64

#endif /* __ppc64__ || __PPC64__ */


#endif

#endif /* __OSINLINE__ */
