function Makename=ilib_gen_Make(name,tables,files,libs,makename,with_gateway,ldflags,cflags,fflags,flag)
// flag 'c' or 'f' used with lcc 
// Copyright Enpc 
//------------------------------------
// generate a Makefile for gateway
  if argn(2)<6 then with_gateway=%t,ldflags='',cflags='',fflags='';end
  files=strsubst(strsubst(files,'.obj','') ,'.o',''); //compat
  // change table if necessary 
  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 
  for it = 1:L 
    table = tables(it);
    [mt,nt]=size(table);
    if nt==2 then col= "csci"; table = [table, col(ones(mt,1))];nt=3; end 
    if nt<>3 then error('second argument has wrong size ');end 
    tables(it)=table;
  end
      
  comp_target = COMPILER;
  if with_lcc() == %T then
  	Makename = makename+'.lcc'
  	flag='c'
  	ilib_gen_Make_lcc(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags,flag)
  else if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then Makename = makename+'.mak'
      ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
     case 'gcc' then 
      Makename = makename;
      ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
    else
       Makename = makename;
       ilib_gen_Make_win32(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
    end
  else
     Makename = makename;
     ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  end
  end
endfunction

function ilib_gen_Make_unix(name,tables,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SCIDIR = %s\n",SCI);
  mfprintf(fd,"OBJS = ")
  for x=files(:)' ; 
    mfprintf(fd," %s.o",x);
  end
  
  if typeof(tables)<>'list' then 
    tables= list(tables)
  end

  L=length(tables); 
  
  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s.o",name);
    else
       for i=1:L , mfprintf(fd," %s.o",name+string(i));end 
    end
  end
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s.o",table(i,2));
      end
    end
  end
  mfprintf(fd,"\n") ;
  mfprintf(fd,"LIBRARY = %s.a\n",name);
  mfprintf(fd,"include $(SCIDIR)/Makefile.incl\n");
  if getenv('WIN32','NO')=='OK' then
    // for cygwin 
    mfprintf(fd,"OTHERLIBS = ");
    for x=libs(:)' ; mfprintf(fd," %s.a",x);end
    mfprintf(fd,"\n");
    mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
    mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction=mex$* "+ fflags +"\n"); 
  else
     mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DmexFunction=mex_$* "+cflags+ "\n");
     mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -Dmexfunction=mex$* "+fflags+ "\n");
  end
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+ "\n");
  if getenv('WIN32','NO')=='OK' then
    // cygwin assumed : we use a specific makedll 
    // and not libtool up to now XXX 
    mfprintf(fd,"include $(SCIDIR)/config/Makecygdll.incl\n");
  else
     mfprintf(fd,"include $(SCIDIR)/config/Makeso.incl\n");
  end
  mclose(fd);

endfunction


function ilib_gen_Make_win32(name,table,files,libs,Makename,with_gateway,ldflags,cflags,fflags)
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SHELL = /bin/sh\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"SCIDIR1 =%s\n",pathconvert(SCI,%f,%f,'w'));
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = %s\n",name);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s.obj",x);end

  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 

  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s.obj",name);
    else
       for i=1:L , mfprintf(fd," %s.obj",name+string(i));end 
    end
  end
  
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
 
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s.obj",table(i,2));
      end
    end
  end
  mfprintf(fd,"\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS = ");
  for x=libs(:)' ; mfprintf(fd," %s.ilib",x);end
  mfprintf(fd,"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\Makefile.incl.mak\n");
  mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
  mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction=mex$* "+ fflags +"\n"); 
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\config\\Makedll.incl \n");
  mclose(fd);
endfunction
//------------------------------------------------------------------------------------------------
         
function ilib_gen_Make_lcc(name,table,files,libs,Makename,with_gateway,ldflags,cflags,fflags,flag)
// Allan CORNET
//INRIA 2004
  fd=mopen(Makename,"w");
  mfprintf(fd,"# ------------------------------------------------------------\n");
  mfprintf(fd,"# generated by builder.sce (lcc 1): Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------------\n\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"SCIDIR1 =%s\n",pathconvert(SCI,%f,%f,'w'));
  mfprintf(fd,"DUMPEXTS=""$(SCIDIR1)\\bin\\dumpexts""\n");
  if ( with_atlas()==%T ) then
  	mfprintf(fd,"SCIIMPLIB=$(SCIDIR1)\\bin\\LibScilabLCC.lib $(SCIDIR1)\\bin\\atlaslcc.lib $(SCIDIR1)\\bin\\libf2clcc.lib $(SCIDIR1)\\bin\\arpacklcc.lib $(SCIDIR1)\\bin\\lapacklcc.lib\n\n");
  else
  	mfprintf(fd,"SCIIMPLIB=$(SCIDIR1)\\bin\\LibScilabLCC.lib\n\n");
  end
  mfprintf(fd,"CC=lcc\n");
  mfprintf(fd,"LINKER=lcclnk\n");
  mfprintf(fd,"CFLAGS= -s -ansic msvcrt.lib -I""$(SCIDIR)/routines"" -I""$(SCIDIR)/routines/f2c"" -Dmexfunction_=mex$*_ -DmexFunction=mex_$* -DWIN32 -DSTRICT -DFORDLL -D__STDC__ "+ cflags +" \n"); 
  
  mfprintf(fd,"LINKER_FLAGS=-dll -nounderscores\n");
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"O=.obj\n");
 
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = %s\n",name);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s$(O)",x);end

  if typeof(table)<>'list' then 
    tables= list(table)
  end
  
  L=length(table); 

  if with_gateway then 
    if L==1 then 
      mfprintf(fd," %s$(O)",name);
    else
       for i=1:L , mfprintf(fd," %s$(O)",name+string(i));end 
    end
  end
  
  for it=1:L 
    table = tables(it)
    [mt,nt]=size(table);
 
    for i=1:mt ; 
      // mex files to be added 
      if table(i,3)=='cmex' | table(i,3)=='fmex' | table(i,3)=='Fmex' 
	mfprintf(fd," %s$(O)",table(i,2));
      end
    end
  end
  
  
  mfprintf(fd,"\n\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS =");
  
  for x=libs(:)' ; mfprintf(fd," %s.ilib",x);end
  mfprintf(fd,"\n");
  
  mfprintf(fd,"\n");
  
  mfprintf(fd,"\nall :: $(LIBRARY).dll\n");
  mfprintf(fd,"\n$(LIBRARY).dll: $(OBJS)\n");
  mfprintf(fd,"	$(DUMPEXTS) -o ""$(LIBRARY).def"" ""$*"" $(OBJS)\n");
  mfprintf(fd,"	$(LINKER) $(LINKER_FLAGS) $(OBJS) $(OTHERLIBS) $(SCIIMPLIB) $(XLIBSBIN) $(TERMCAPLIB) $(EXTRA_LDFLAGS) $*.def -o $(LIBRARY).dll\n\n");
 

  for x=files(:)' ;
  	x=strsubst(x,".obj","");
   	x=strsubst(x,".o","");
  	mfprintf(fd,"%s$(O):\n",x);
  	mfprintf(fd,"	$(CC) $(CFLAGS) $*.c\n\n");
  end


  if with_gateway then 
    if L==1 then 
      mfprintf(fd,"\n%s$(O):\n",name);
      mfprintf(fd,"	$(CC) $(CFLAGS) $*.c\n");
    else
       for i=1:L ;
       mfprintf(fd,"\n%s$(O):\n",name+string(i));
       mfprintf(fd,"	$(CC) $(CFLAGS) $*.c\n");
       end 
    end
  end
  
  	
  mfprintf(fd,"\nclean:\n");
  mfprintf(fd,"	del *.obj\n");
  mfprintf(fd,"	del *.dll\n");
  mfprintf(fd,"	del *.lib\n");
  mfprintf(fd,"	del *.def\n");
 
 mclose(fd);

endfunction