/*
 * insertview.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __ROBOTOP_INSERTVIEW_H__
#define __ROBOTOP_INSERTVIEW_H__


#include <wx/wx.h>
#include <wx/process.h>
#include "wxext.h" // bug fix

class TourData;
class TournamentFrame;
class RoboTourProcess;

struct SimStatus { // all the variables saving our current sim status
	bool isCur; // is it a "current" bot
	int numFile, totalFiles; // it is the Nth of M files in this batch sim
	int numSim; // against how many has it already played?
	int numRepeats; // how many repeats?
	// the current bot name is always the last in the respective array
	// but we'll need the local name too
	wxString localFile;
	// the robotour executable stored for convenient access
	wxString rtExe; 
	wxString optionSet;
	int chartSize;
	// and last but not least... "our" competition folder, complete w/ final "slash"
	wxString tourFolder;
};

// Define a new frame type: this is going to be our main frame
class InsertFrame : public wxxMDIChildFrame
{
public:
	InsertFrame(TournamentFrame* charts);
	bool Destroy();

	wxMenuBar* CreateMenu();
	void InitToolBar(wxToolBar* toolBar);

	bool IsRunning();

	// copies the selected files to the newbots folder
	bool CopyFiles(const wxArrayString& files);
	// scans the newbots and curbots folder for files and prepares the RoboTour run for them
	void ScanForFiles();
	int GetNumWaitingFiles(); 
	// actually runs RoboTour w/ the current files (this is mainly done in OnStart())
	//void RunRoboTour();

	void OnStart(wxCommandEvent& event);
	void OnCloseCommand(wxCommandEvent& event);
	void OnCloseWindow(wxCloseEvent& event);
	void OnIdle(wxIdleEvent& event);
	void OnTimer(wxTimerEvent& event);

private:
	TournamentFrame* chartsFrame;
	friend class TournamentFrame; // so that it can set ours to 0
	RoboTourProcess* process;
	friend class RoboTourProcess;

	void UpdateTitle();

	// files in the curbots folder
	wxArrayString curFiles;
	// files in the newbots folder
	wxArrayString newFiles;

	wxTimer* refreshTimer; // makes sure that RT output is catched; re-scans the folders
	wxTextCtrl* rtOutputWin;
	wxToolBar* toolBar;
	wxGauge* progressBar;
	wxStaticText* progressLabel;
	wxStaticText* statusLabel;
	void InitProgress(); // you needn't call it, it's done after finishing the tour and after scanning for files
	void SetProgress(int numPlayed); // keeps pBar and pLabel in synch

	void NextFile(); // called by RTP after sim done

	bool running;

	SimStatus status; // our simulation status

	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE();
};



class RoboTourProcess : public wxProcess 
{
public:
	RoboTourProcess(InsertFrame* parent, const wxString& args);
	~RoboTourProcess(); // NOTE: do not assume that parent is still valid in there!

    virtual void OnTerminate(int pid, int status);
    virtual bool HasInput();

	void Break(); // cancel simulation 

private:
	friend class InsertFrame; 

	InsertFrame* parent;
	int pid;
};


// IDs for the controls and the menu commands
enum
{
	// tool bar items
	InsertFrame_Start = 300,
	InsertFrame_Timer
};

#endif // file
