/****************************************************************************
** Interface to the GUI.
**
**   Created : Tue 04 May 12:09:08 2004
**        by : Carol Akan using kate editor
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
** This are the classes for the StructureWidget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/

#ifndef STRUCTURETOOLBAR_H
#define STRUCTURETOOLBAR_H

#include <qdockwindow.h>
#include <qlistview.h>
#include <qsize.h>

class SourceToolBar;
class MenuPreview;
class MenuObject;
class DVDMenu;

class StructureItem : public QListViewItem
{
public:
  enum enType { Unknown=0, DVDProject, MainMenu, SubMenu, Intro, Extro, Background, Audio, Buttons, Button, Frame, Text, Image, Video, Highlighted, Selected, Geometry, Modifiers, Attributes };

  StructureItem ( MenuObject *pMenuObject, enType type, QListViewItem *pListViewItem, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem (pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( type ); m_pMenuObject = pMenuObject; };

  StructureItem ( MenuObject *pMenuObject, enType type, QListViewItem *pParent, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pParent, pAfter, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( type ); m_pMenuObject = pMenuObject; };

  StructureItem ( MenuPreview *pMenuPreview, enType type, QListViewItem *pListViewItem, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
      : QListViewItem (pListViewItem, pAfter, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( type ); m_pMenuPreview = pMenuPreview; };

  StructureItem ( DVDMenu *pDVDMenu, enType type, QListViewItem *pListViewItem, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem (pListViewItem, pAfter, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( type ); m_pDVDMenu = pDVDMenu; };

  StructureItem ( QListViewItem *pListViewItem, enType type, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( type ); };

  StructureItem ( QListView *pListView, enType type, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pListView, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( type ); };

    virtual ~StructureItem ( );
    virtual int rtti       ( ) const { return 5000; };

    void initMe  ( enType );
    void createContextMenu     ( QPoint );
    void createIntroExtroMenu  ( QPoint );
    void setText ( QString &, QString & );
    void setText ( int,       QString & );
    void setPixmap             ( enType );

    StructureItem  *setSibling ( MenuObject *,  StructureItem *, QString, QString );
    StructureItem  *setSibling ( DVDMenu *,     StructureItem *, QString, QString );
    StructureItem  *setSibling ( MenuPreview *, StructureItem *, QString, QString );
    StructureItem  *lastChild  ( );
    MenuObject  *getMenuObject ( ) { return m_pMenuObject; };

private:
    MenuObject  *m_pMenuObject;
    MenuPreview *m_pMenuPreview;
    enType       m_type;
    DVDMenu     *m_pDVDMenu; // used or Intro / Extro ...
    static int RTTI;
};

class StructureToolBar : public QWidget //QDockWindow
{
  Q_OBJECT

public:
  StructureToolBar ( QDockWindow * );
  virtual ~StructureToolBar   ( );

  StructureItem *clean   ( bool );

public slots:
  virtual void slotRightClickedOnStructure ( QListViewItem *, const QPoint &, int );
  virtual void slotRightClickedOnTitleset  ( QListViewItem *, const QPoint &, int );
  virtual void slotTabChanged ( QWidget * );

private:
  SourceToolBar *m_pSourceToolBar;
};

#endif // STRUCTURETOOLBAR_H

