/****************************************************************************
** Class DialogFilter
**
**   Created : Sun May 22 09:13:25 2009
**        by : Varol Okan, using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef DIALOGALPHATRANS_H
#define DIALOGALPHATRANS_H

#include <qiconview.h>
#include <qvaluelist.h>

#include "uidialoglibrary.h"

class DialogAlphaTrans : public uiDialogLibrary
{
  Q_OBJECT

protected:
    class FilterPart {
    public:
      FilterPart ( QIconView *, QString );
      QIconView   *pIconView;
      QString      qsFilterPath;
    };

    class Item : public QIconViewItem  {
    public:
      Item ( QIconView *, const QString &, const QPixmap &, bool );
      void setChecked  ( bool );
      void toggleCheck ( );
      bool isChecked   ( );
      QString fileName ( );

    protected:
      virtual void calcRect ( const QString &s=QString::null );

    private:
      void refreshIcon ( );

    private:
      bool    m_bChecked;
      QString m_qsFileName;
      QPixmap m_pixmap;
    };

public:
           DialogAlphaTrans ( QStringList &, QWidget *p=0, const char *n=NULL, bool m=FALSE, WFlags f=0 );
  virtual ~DialogAlphaTrans ( );

  bool isChecked ( QString & );
  void createTab ( QString, QString, QStringList & );

protected:
  void initMe ( );

protected slots:
  virtual void accept        ( );
  virtual void slotRefresh   ( );
  virtual void slotAfterInit ( );
  virtual void slotClicked   ( int, QIconViewItem *, const QPoint & );

protected:
  int m_iThumbSize;
  QValueList<FilterPart *> m_listFilter;
  QStringList              m_listEnabled;
};

#endif // DIALOGALPHATRANS_H

