/*
 *	bootstrap_prototypes.h
 */

#ifndef __csetjmp__
#include <setjmp.h>
#endif

#include "asm_a.out.h"
#include "asm_elf.h"
#include "linux_elf.h"

struct Kernel_Areas
{
	unsigned long	start;		/* memptr */
	unsigned long	size; 	/* kernel_size */
	unsigned long	entry;		/* jmp location */
};

struct Ramdisk_Areas
{
	unsigned long	start;
	unsigned long	size;
};

/*
 *	complete_kernel_areas
 *
 *	All of these areas (kernel.x, boot_info, and ramdisk.x) are
 *	relative to some base.  The base begins life as a logical address
 *	in the MacOS memory configuration and then changes later into a
 *	physical address for moving the kernel to launch.
 *	There will probably be an interim spot for the kernel, getting it
 *	all in one bank (not to cross bank boundaries) and to not overlap
 *	the final destination.
 */
struct Kernel_Offsets
{
	struct Kernel_Areas		 kernel;

	unsigned long			 boot_info;

	struct Ramdisk_Areas	 ramdisk;
};

struct Kernel_Image_Info
{
	int						 type;
	struct exec_aout		 exec;
	
	int						 aout_text_offset;
	
	Elf32_Phdr				*phdrs_elf;
	Elf32_Ehdr				 exec_elf;
};

#define KERNEL_AOUT		0
#define KERNEL_ELF		1

/* bootstrap.c */
extern jmp_buf			jmpState;
extern struct bootinfo	bi;
extern unsigned long	kernel_entry;
extern unsigned long	v_kernel_major, v_kernel_minor;
void					boot(void);

/* parse_image.c */
unsigned long	parse_kernel_image (struct Kernel_Image_Info *kernel_info);
void			parse_read_kernel (struct Kernel_Image_Info *kernel_info, unsigned long where);
unsigned long	parse_ramdisk (void);
void			parse_read_ramdisk (unsigned long size, unsigned long where);

/* boot_helper.c */
unsigned char /*Boolean*/ boot_init_bootinfo (void);
void			boot_print_mach_specs (void);
void			boot_dump_boot_info (char *v2_data, unsigned long major_version, unsigned long minor_version);
void			boot_dump_segment_info (unsigned long start, struct Kernel_Image_Info *info,
						struct Kernel_Offsets *kernel_offsets,
						unsigned long major_version, unsigned long minor_version);
unsigned long	check_bootinfo_version(char *memptr);
unsigned long	LogicalToPhysical (unsigned long logAddr);
unsigned long	PhysicalToLogical (unsigned long logAddr);
void			memory_init (void);
void			set_kernel_bootinfo(char *dst, unsigned long major_version, unsigned long minor_version);
