/*
 * Package org.OpenJUMP.layer.style.classification pour JUMP
 *
 * Copyright (C) 2004
 * Olivier Bedel, ingnieur informaticien laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien.
 * Cline Foureau, stagiaire MIAGE, laboratoire Reso UMR ESO 6590.
 * Erwan Bocher, doctorant en gographie, laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien
 *
 * Date de cration : 19 aout 2004
 *
 * Dvelopp dans le cadre du Projet APARAD 
 *  (Laboratoire Reso UMR ESO 6590 CNRS / Bassin Versant du Jaudy-Guindy-Bizien)
 *    Responsable : Erwan BOCHER
 *    Dveloppeurs : Cline FOUREAU, Olivier BEDEL
 *
 * olivier.bedel@uhb.fr ou olivier.bedel@yahoo.fr
 * erwan.bocher@uhb.fr ou erwan.bocher@free.fr
 * celine.foureau@uhb.fr ou celine.foureau@wanadoo.fr
 * 
 * Ce package hrite de la licence GPL de JUMP. Il est rgi par la licence CeCILL soumise au droit franais et
 * respectant les principes de diffusion des logiciels libres. (http://www.cecill.info)
 * 
 */
package org.openjump.core.ui.style.classification;

import java.text.NumberFormat;
import java.util.Comparator;
import java.util.TreeMap;

/** 
 * @author FOUREAU_C
 */

public class Interval {
	private Number min;

	private Number max;

	private boolean includingMin;

	private boolean includingMax;

	public Interval(Number min, boolean includingMin, Number max,
			boolean includingMax) {
		this.min = min;
		this.max = max;
		this.includingMin = includingMin;
		this.includingMax = includingMax;
	}

	public Number getMin() {
		return min;
	}

	public Number getMax() {
		return max;
	}

	public void setMin(Number min) {
		this.min = min;
	}

	public void setMax(Number max) {
		this.max = max;
	}

	public boolean isIncludingMin() {
		return includingMin;
	}

	public boolean isIncludingMax() {
		return includingMax;
	}

	public void setIncludingMin(boolean b) {
		includingMin = b;
	}

	public void setIncludingMax(boolean b) {
		includingMax = b;
	}

	public String toString() {
		String libelle = "";
		NumberFormat nf = NumberFormat.getInstance();
		if (min.equals(max)) {
			libelle = nf.format(min);
		} else {
			libelle = nf.format(min) + " - " + nf.format(max);
		}
		return libelle;
	}

	public static final Comparator INTERVAL_COMPARATOR = new Comparator() {
		public int compare(Object o1, Object o2) {
			Interval interval1 = o1 instanceof Interval ? (Interval) o1
					: new Interval((Number) o1, true, (Number) o1, true);
			Interval interval2 = o2 instanceof Interval ? (Interval) o2
					: new Interval((Number) o2, true, (Number) o2, true);
			int max1CompareToMin2 = ((Comparable) interval1.getMax())
					.compareTo(interval2.getMin());
			if (max1CompareToMin2 < 0
					|| (max1CompareToMin2 == 0 && (!interval1.isIncludingMax() || !interval2
							.isIncludingMin()))) {
				return -1;
			}
			int min1CompareToMax2 = ((Comparable) interval1.getMin())
					.compareTo(interval2.getMax());
			if (min1CompareToMax2 > 0
					|| (min1CompareToMax2 == 0 && (!interval1.isIncludingMin() || !interval2
							.isIncludingMax()))) {
				return 1;
			}
			return 0;
		}
	};

	//Trivial, but necessary for Java2XML serialization. [Jon Aquino]
	public static class IntervalTreeMap extends TreeMap {
		public IntervalTreeMap() {
			super(INTERVAL_COMPARATOR);
		}
	}
}