/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef SYSTEMMEMORY_COMMON_H_
#define SYSTEMMEMORY_COMMON_H_

#include <Common.h>
#include <SMBIOS.h>

// CIM_Memory.Access Values Map (inherited from CIM_StorageExtent)
#define ACCESS_UNKNOWN		0
#define ACCESS_READABLE		1
#define ACCESS_WRITEABLE	2
#define ACCESS_READWRITE	3
#define ACCESS_WRITE_ONCE	4

// CIM_Memory.OperationalStatus Values Map (inherited from CIM_ManagedSystemElement)
#define OPS_UNKNOWN						0
#define OPS_OTHER						1
#define OPS_OK							2
#define OPS_DEGRADED					3
#define OPS_STRESSED					4
#define OPS_PREDICTIVE_FAILURE			5
#define OPS_ERROR						6
#define OPS_NON_RECOVERABLE_ERROR		7
#define OPS_STARTING					8
#define OPS_STOPPING					9
#define OPS_STOPPED						10
#define OPS_IN_SERVICE					11
#define OPS_NO_CONTACT					12
#define OPS_LOST_COMMUNICATION			13
#define OPS_ABORTED						14
#define OPS_DORMANT						15
#define OPS_SUPPORTING_ENTITY_IN_ERROR	16
#define OPS_COMPLETED					17
#define OPS_POWER_MODE					18

// CIM_Memory.HealthState Values Map (inherited from CIM_ManagedSystemElement)
#define HS_UNKNOWN					0
#define HS_OK						5
#define HS_DEGRADED_WARNING			10
#define HS_MINOR_FAILURE			15
#define HS_MAJOR_FAILURE			20
#define HS_CRITICAL_FAILURE			25
#define HS_NON_RECOVERABLE_ERROR	30

// CIM_Memory.EnabledState Values Map (inherited from CIM_EnabledLogicalElement)
#define ES_ENABLED	2

// CIM_Memory.RequestedState Values Map (inherited from CIM_EnabledLogicalElement)
#define RS_NOT_APPLICABLE 12

bool CF_isVolatileMemory(BYTE memtype, WORD memtype_detail);

int CF_getAccess(BYTE memtype);

int CF_getOperationalStatus(vector<unsigned short>& output,vector<void*> mem_error);

int CF_getHealthState(vector<void*> mem_error);

#endif /*SYSTEMMEMORY_COMMON_H_*/
