/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_REALIZESACCESS_H_
#define OPENDRIM_REALIZESACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_Realizes.h"
#include "assocOpenDRIM_Realizes.h"

int PhysicalAsset_OpenDRIM_Realizes_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Realizes>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Realizes_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Realizes& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Realizes& newInstance, const OpenDRIM_Realizes& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Realizes& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Realizes& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_Realizes_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Realizes_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Realizes_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_Realizes>& OpenDRIM_Realizes_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Realizes_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_Realizes>& OpenDRIM_Realizes_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Realizes_populate(OpenDRIM_Realizes& instance, string& errorMessage);

#endif /*OPENDRIM_REALIZESACCESS_H_*/
