/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_PCIeSwitchAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_PCIeSwitch";
string systemName;
string deviceID;

int PCI_OpenDRIM_PCIeSwitch_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int PCI_OpenDRIM_PCIeSwitch_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PCI_OpenDRIM_PCIeSwitch_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PCIeSwitch>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	vector<string> device_lines;
	CF_assert(CF_runCommandToLines("lspci -n", device_lines, 0, errorMessage));
	vector<string> deviceIDs;
		
	for(size_t i=0; i<device_lines.size()-1; i++)
	{
		OpenDRIM_PCIeSwitch instance;
		instance.setSystemCreationClassName(systemCreationClassName);
		instance.setSystemName(systemName);
		instance.setCreationClassName(creationClassName);
		CF_splitTextBySpace(deviceIDs,device_lines[i]);
		instance.setDeviceID(deviceIDs[2]);
		
		if (discriminant == "ei")
			CF_assert(PCI_OpenDRIM_PCIeSwitch_populate(instance, errorMessage));
		
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int PCI_OpenDRIM_PCIeSwitch_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PCIeSwitch& instance, const char** properties, string& errorMessage) {
	_E_;
	string command;
	string device;
	
	command = "lspci -d " + instance.DeviceID;
	CF_runCommandFL(command,device,errorMessage);
	
	if (instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.SystemName != systemName ||
			device == "")
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(PCI_OpenDRIM_PCIeSwitch_populate(instance,errorMessage));
	_L_;
	return OK;
}

int PCI_OpenDRIM_PCIeSwitch_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& newInstance, const OpenDRIM_PCIeSwitch& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_RequestStateChange_In& in, OpenDRIM_PCIeSwitch_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_SetPowerState_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_EnableDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_OnlineDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, const OpenDRIM_PCIeSwitch_QuiesceDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_BISTExecution(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIeSwitch& instance, unsigned char& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_PCIeSwitch_populate(OpenDRIM_PCIeSwitch& instance, string& errorMessage) {
	_E_;
	vector<string> pcidevices_elements;
	string busNumber, deviceNumber, functionNumber;
	string command;
	string device;
	
	command = "lspci -d " + instance.DeviceID;
	CF_runCommandFL(command,device,errorMessage);

	instance.setElementName(device.substr(8));
	
	CF_splitText(pcidevices_elements,device, ":.");
	busNumber = pcidevices_elements[0];
	deviceNumber = pcidevices_elements[1];
	functionNumber = pcidevices_elements[2];
	
	//converting from string to char
	const char *bn, *dn, *fn;
	bn = busNumber.c_str();
	dn = deviceNumber.c_str();
	fn = functionNumber.c_str();
	
	//converting from hex to dec
	instance.setBusNumber(HexToInteger(bn));
	instance.setDeviceNumber(HexToInteger(dn));
	instance.setFunctionNumber(HexToInteger(fn));
	
	instance.setHealthState(0);
	instance.setPrimaryStatus(0);
	_L_;
	return OK;
}

