/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_SUBP_H__
#define __OGMRIP_SUBP_H__

#include <ogmrip-codec.h>
#include <ogmrip-enums.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_SUBP          (ogmrip_subp_get_type ())
#define OGMRIP_SUBP(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_SUBP, OGMRipSubp))
#define OGMRIP_SUBP_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_SUBP, OGMRipSubpClass))
#define OGMRIP_IS_SUBP(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_SUBP))
#define OGMRIP_IS_SUBP_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_SUBP))

typedef struct _OGMRipSubp      OGMRipSubp;
typedef struct _OGMRipSubpPriv  OGMRipSubpPriv;
typedef struct _OGMRipSubpClass OGMRipSubpClass;

struct _OGMRipSubp
{
  OGMRipCodec parent_instance;

  OGMRipSubpPriv *priv;
};

struct _OGMRipSubpClass
{
  OGMRipCodecClass parent_class;
};

GType              ogmrip_subp_get_type            (void);

void               ogmrip_subp_set_dvd_subp_stream (OGMRipSubp       *subp, 
                                                    OGMDvdSubpStream *stream);
OGMDvdSubpStream * ogmrip_subp_get_dvd_subp_stream (OGMRipSubp       *subp);

void               ogmrip_subp_set_forced_only     (OGMRipSubp       *subp,
                                                    gboolean         forced_only);
gboolean           ogmrip_subp_get_forced_only     (OGMRipSubp       *subp);

void               ogmrip_subp_set_charset         (OGMRipSubp       *subp,
                                                    OGMRipCharset    charset);
gint               ogmrip_subp_get_charset         (OGMRipSubp       *subp);

void               ogmrip_subp_set_eol_style       (OGMRipSubp       *subp,
                                                    OGMRipEolStyle   eol);
gint               ogmrip_subp_get_eol_style       (OGMRipSubp       *subp);

G_END_DECLS

#endif /* __OGMRIP_SUBP_H__ */

