/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_AUDIO_H__
#define __OGMRIP_AUDIO_H__

#include <ogmrip-codec.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_AUDIO           (ogmrip_audio_get_type ())
#define OGMRIP_AUDIO(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_AUDIO, OGMRipAudio))
#define OGMRIP_AUDIO_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_AUDIO, OGMRipAudioClass))
#define OGMRIP_IS_AUDIO(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_AUDIO))
#define OGMRIP_IS_AUDIO_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_AUDIO))
#define OGMRIP_AUDIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), OGMRIP_TYPE_AUDIO, OGMRipAudioClass))

typedef struct _OGMRipAudio      OGMRipAudio;
typedef struct _OGMRipAudioPriv  OGMRipAudioPriv;
typedef struct _OGMRipAudioClass OGMRipAudioClass;

struct _OGMRipAudio
{
  OGMRipCodec parent_instance;

  OGMRipAudioPriv *priv;
};

struct _OGMRipAudioClass
{
  OGMRipCodecClass parent_class;

  /* vtable */
  gint (* get_samples_per_frame) (OGMRipAudio *audio);
};

GType               ogmrip_audio_get_type              (void);

void                ogmrip_audio_set_dvd_audio_stream  (OGMRipAudio         *audio, 
                                                        OGMDvdAudioStream   *stream);
OGMDvdAudioStream * ogmrip_audio_get_dvd_audio_stream  (OGMRipAudio         *audio);
void                ogmrip_audio_set_fast              (OGMRipAudio         *audio,
                                                        gboolean            fast);
gboolean            ogmrip_audio_get_fast              (OGMRipAudio         *audio);
void                ogmrip_audio_set_quality           (OGMRipAudio         *audio,
                                                        guint               quality);
gint                ogmrip_audio_get_quality           (OGMRipAudio         *audio);
void                ogmrip_audio_set_normalize         (OGMRipAudio         *audio,
                                                        gboolean            normalize);
gboolean            ogmrip_audio_get_normalize         (OGMRipAudio         *audio);
void                ogmrip_audio_set_channels          (OGMRipAudio         *audio,
                                                        OGMDvdAudioChannels channels);
gint                ogmrip_audio_get_channels          (OGMRipAudio         *audio);
void                ogmrip_audio_set_sample_rate       (OGMRipAudio         *audio,
                                                        guint               srate);
gint                ogmrip_audio_get_sample_rate       (OGMRipAudio         *audio);
gint                ogmrip_audio_get_samples_per_frame (OGMRipAudio         *audio);

G_END_DECLS

#endif /* __OGMRIP_AUDIO_H__ */

