#line 1 "cfunc.mod"
#include "cm.h"
#line 1 "cfunc.mod"
/* ===========================================================================
FILE    cfunc.mod

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of a capacitor code model
    with voltage type initial conditions.

INTERFACES

    cm_capacitor()

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

void *malloc(int);
void  free(void *);


#define VC  0


void cm_capacitor (Mif_Private_t *private)
{
    Complex_t   ac_gain;
    double      partial;
    double      ramp_factor;
    double      *vc;


    /* Get the ramp factor from the .option ramptime */
    ramp_factor = cm_analog_ramp_factor();

    /* Initialize/access instance specific storage for capacitor voltage */
    if(private->circuit.init) {
        vc = cm_analog_alloc(VC, sizeof(double));
        *vc = private->param[1]->element[0].rvalue * cm_analog_ramp_factor();
    }
    else {
        vc = cm_analog_get_ptr(VC, 0);
    }

    /* Compute the output */
    if(private->circuit.anal_type == DC) {
        private->conn[0]->port[0]->output.rvalue = private->param[1]->element[0].rvalue * ramp_factor;
         private->conn[0]->port[0]->partial[0].port[0] = 0.0;
    }
    else if(private->circuit.anal_type == AC) {
        ac_gain.real = 0.0;
        ac_gain.imag = -1.0 / private->circuit.frequency / private->param[0]->element[0].rvalue;
         private->conn[0]->port[0]->ac_gain[0].port[0] = ac_gain;
    }
    else if(private->circuit.anal_type == TRANSIENT) {
        if(ramp_factor < 1.0) {
            *vc = private->param[1]->element[0].rvalue * ramp_factor;
            private->conn[0]->port[0]->output.rvalue = *vc;
             private->conn[0]->port[0]->partial[0].port[0] = 0.0;
        }
        else {
            cm_analog_integrate(private->conn[0]->port[0]->input.rvalue / private->param[0]->element[0].rvalue, vc, &partial);
            partial /= private->param[0]->element[0].rvalue;
            private->conn[0]->port[0]->output.rvalue = *vc;
             private->conn[0]->port[0]->partial[0].port[0] = partial;
        }
    }
}

