; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
; =file
; mythtv.iss
;
; =description
; InnoSetup setup file for win32 installation of mythtv
; For now, simple *.* copy of all source files to destination computer
; and a few cmd to launch front and backend
; =revision
;
; =author
; Arnon

; TODO
; - More selective copy of sources, especially share
; - Allow selective full/remote/local installation
; - Add mqsql checks and configuration
; - If user selects different app or appdata paths, add env variables

;Uncomment next line to test iss package- setup will not include any files
;#define TESTING

; Version information is generated by MythInstaller.bat
#ifndef TESTING
#include <versioninfo.iss>
#endif

#ifdef TESTING
#define MyAppName "MythTV 0.21"
#define MyAppVerName "MythtTV 0.21"
#define MyAppPublisher "www.mythtv.org"
#define MyAppURL "www.mythtv.org"
#define appdata "C:\Program Files\Mythtv"
#endif

[Setup]
AppName={#MyAppName}
AppVerName={#MyAppVerName}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\mythtv
DisableDirPage=yes
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
OutputDir=c:\mythtv\setup
OutputBaseFilename=MythTvSetup
Compression=lzma
SolidCompression=yes
AppModifyPath="{app}\UninsHs.exe" /m0=AppName


[Languages]
Name: english; MessagesFile: compiler:Default.isl

[Tasks]
;Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked

[Files]
; File list is generated by MythInstaller.bat
Source: isxdl.dll; Flags: dontcopy
Source: WizModernSmallImage-IS.bmp; Flags: dontcopy
Source: mysql.gif; Flags: dontcopy
Source: UninsHs.exe; DestDir: {app}; Flags: restartreplace
Source: configuremysql.vbs; DestDir: {app}
#ifndef TESTING
#include <files.iss>
#endif

[Icons]
Name: {group}\Myth Frontend; Filename: {app}\mythfrontend.exe; WorkingDir: {app}
Name: {group}\Myth Backend; Filename: {app}\mythbackend.exe; WorkingDir: {app}
Name: {group}\Setup; Filename: {app}\mythtv-setup.exe; WorkingDir: {app}
Name: {group}\Readme; Filename: {app}\readme.txt; WorkingDir: {app}
Name: {group}\Uninstall {#MyAppName}; Filename: {app}\UninsHs.exe; Parameters: /u0={#MyAppName}
Name: {group}\Utilities\MythCommFlag; Filename: {app}\mythcommflag.exe; WorkingDir: {app}
Name: {group}\Utilities\MythFillDatabase; Filename: {app}\MythFillDatabase.exe; WorkingDir: {app}
Name: {group}\Utilities\Mythtvosd; Filename: {app}\Mythtvosd.exe; WorkingDir: {app}
Name: {group}\Utilities\MythWelcome; Filename: {app}\MythWelcome.exe; WorkingDir: {app}

[Dirs]
Name: {app}\sqldrivers
Name: {app}\share
Name: {app}\share\mythtv
Name: {app}\share\mythtv\themes
Name: {app}\share\mythtv\mythweather
Name: {app}\share\mythtv\i18n
Name: {app}\lib
Name: {app}\lib\mythtv
Name: {app}\lib\mythtv\plugins
Name: {app}\lib\mythtv\filters
Name: {localappdata}\mythtv
[INI]

Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBHostName; String: {code:GetUser|IPAddress}
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBHostPing; String: {code:GetUser|Ping}
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBUserName; String: {code:GetUser|DBUsername}
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBPassword; String: {code:GetUser|DBPassword}
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBName; String: mythconverg
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: DBType; String: QMYSQL3
Filename: {userappdata}\mythtv\mysql.txt; Section: #; Key: LocalHostName; String: {computername}

[Run]
Filename: {sys}\cscript.exe; Parameters: " //H:CScript {app}\configuremysql.vbs"; WorkingDir: {app}; Flags: shellexec runascurrentuser; Tasks: ; Languages: ; Check: ConfigureMySQL
Filename: {sys}\msiexec.exe; Parameters: /x {tmp}\mysql-essential-5.0.45-win32.msi /quiet INSTALLLEVEL=2; Description: Installing MySQL; Flags: skipifdoesntexist; Check: InstallMySQL
Filename: {sys}\notepad.exe; Parameters: {app}\readme.txt; WorkingDir: {app}; Flags: shellexec runascurrentuser; Tasks: ; Languages: 
Filename: {app}\UninsHs.exe; Parameters: /r0=AppName,{language},{srcexe}; Flags: runminimized

[InstallDelete]
Name: {app}\package_flag; Type: files

Name: {app}\package_flag; Type: files
Name: {app}\lib; Type: filesandordirs
Name: {app}\mythtv; Type: filesandordirs
Name: {app}\share; Type: filesandordirs
Name: {app}\sqldrivers; Type: filesandordirs

[Code]
var
  LocalRemotePage: TInputOptionWizardPage;
  ConfigureSQL: TInputOptionWizardPage;
  SQLPage: TInputOptionWizardPage;
  RemoteSQLPage: TInputQueryWizardPage;
  BackendPage: TInputQueryWizardPage;
  DownloadMySqlPage: TWizardPage;
  MySQLPathRead, bSQLDetected: Boolean;
  MySQLPath: String;
  MySQLVersion: String;
  FilesDownloaded: Boolean;
  DownloadMySqlCheckBox: TCheckBox;


procedure isxdl_AddFile(URL, Filename: PChar);
external 'isxdl_AddFile@files:isxdl.dll stdcall';
function isxdl_DownloadFiles(hWnd: Integer): Integer;
external 'isxdl_DownloadFiles@files:isxdl.dll stdcall';
function isxdl_SetOption(Option, Value: PChar): Integer;
external 'isxdl_SetOption@files:isxdl.dll stdcall';

function GetModuleHandle(lpModuleName: LongInt): LongInt;
external 'GetModuleHandleA@kernel32.dll stdcall';
function ExtractIcon(hInst: LongInt; lpszExeFileName: PChar; nIconIndex: LongInt): LongInt;
external 'ExtractIconA@shell32.dll stdcall';
function DrawIconEx(hdc: LongInt; xLeft, yTop: Integer; hIcon: LongInt; cxWidth, cyWidth: Integer; istepIfAniCur: LongInt; hbrFlickerFreeDraw, diFlags: LongInt): LongInt;
external 'DrawIconEx@user32.dll stdcall';
function DestroyIcon(hIcon: LongInt): LongInt;
external 'DestroyIcon@user32.dll stdcall';

const
  DI_NORMAL = 3;

// ------------------------------------------------------------------------------------------
// Helper Functions
//
// ------------------------------------------------------------------------------------------

// MySqlInstalled - determines if MySql is already installed
// Returns True or False
function MySqlInstalled: Boolean;
var
  MySqlPathKeyName, MySqlPathValueName, MySqlVersionValueName: String;
begin
  if not MySQLPathRead then begin
    MySqlPathKeyName := 'SOFTWARE\MySQL AB\MySQL Server 5.0';
    Result := RegKeyExists(HKLM, MySqlPathKeyName);
  end;
end;

// InstallMySQL - Should installer install MySQL (True or False)
function InstallMySQL: Boolean;
begin
  Result :=  DownloadMySqlCheckBox.Checked and FilesDownloaded;
end;

// FrontendOnly - did user select Local installation
function FrontendOnly: Boolean;
begin
  if LocalRemotePage.SelectedValueIndex =0 then
    Result := true
  else
    Result := false;
end;

// ConfigureMySQL - Should installer configure MySQL
function ConfigureMySQL: Boolean;
begin
  Result := false

  if DownloadMySqlCheckBox.Checked  and FilesDownloaded and (ConfigureSQL.SelectedValueIndex =0) then
    Result := true;
  if MySqlInstalled and (ConfigureSQL.SelectedValueIndex =0)  then
    Result := true;
end;

// DownloadFile - function to download MySQL
function DownloadFiles(DownloadSQL: Boolean): Boolean;
var
  hWnd: Integer;
  URL, FileName: String;
begin
  isxdl_SetOption('label', 'Downloading extra files');
  isxdl_SetOption('description', 'Please wait while Setup is downloading extra files to your computer.');

  try
    FileName := ExpandConstant('{tmp}\WizModernSmallImage-IS.bmp');
    if not FileExists(FileName) then
      ExtractTemporaryFile(ExtractFileName(FileName));
    isxdl_SetOption('smallwizardimage', FileName);
  except
  end;

  //turn off isxdl resume so it won't leave partially downloaded files behind
  //resuming wouldn't help anyway since we're going to download to {tmp}
  isxdl_SetOption('resume', 'false');

  hWnd := StrToInt(ExpandConstant('{wizardhwnd}'));

  if DownloadSQL then begin
    URL := 'http://mirror.services.wisc.edu/mysql/Downloads/MySQL-5.0/mysql-essential-5.0.45-win32.msi';
    FileName := ExpandConstant('{tmp}\mysql-essential-5.0.45-win32.msi');
    isxdl_AddFile(URL, FileName);
  end;


  if isxdl_DownloadFiles(hWnd) <> 0 then
    FilesDownloaded := True
  else
    SuppressibleMsgBox('Setup could not download the extra files. Try again later or download and install the extra files manually.' + #13#13 + 'Setup will now continue installing normally.', mbError, mb_Ok, idOk);

  Result := True;
end;


// GetUser - Function used by installer to extract the value to write into mysql.txt
function GetUser(Param: String): String;
begin
  // Return a user value
  if Param = 'IPAddress' then begin
  // If user selected Full Installation - local ip address
    if LocalRemotePage.SelectedValueIndex = 0 then
      Result := '127.0.0.1'
    else
      Result := RemoteSQLPage.Values[0];
  end else if Param = 'Ping' then begin
  // If user selected Full Installation - no ping needed
    if LocalRemotePAge.SelectedValueIndex = 0 then
      Result := 'no'
     else
      Result := 'yes';
  end else if Param = 'DBUsername' then
    Result  := RemoteSQLPage.Values[1]
  else if Param = 'DBPassword' then
    Result  := RemoteSQLPage.Values[2]
  else if Param = 'Hostname' then
    Result  := RemoteSQLPage.Values[3]
end;
// ------------------------------------------------------------------------------------------
// Dialog Box Functions
//
// ------------------------------------------------------------------------------------------

function CreateCustomOptionPage(AAfterId: Integer; ACaption, ASubCaption, AIconFileName, ALabel1Caption, ALabel2Caption,
  ACheckCaption: String; var CheckBox: TCheckBox): TWizardPage;
var
  Page: TWizardPage;
  Rect: TRect;
  hIcon: LongInt;
  Label1, Label2: TNewStaticText;
begin
  Page := CreateCustomPage(AAfterID, ACaption, ASubCaption);

  try
    AIconFileName := ExpandConstant('{tmp}\' + AIconFileName);
    if not FileExists(AIconFileName) then
      ExtractTemporaryFile(ExtractFileName(AIconFileName));

    Rect.Left := 0;
    Rect.Top := 0;
    Rect.Right := 32;
    Rect.Bottom := 32;

    hIcon := ExtractIcon(GetModuleHandle(0), AIconFileName, 0);
    try
      with TBitmapImage.Create(Page) do begin
        with Bitmap do begin
          Width := 32;
          Height := 32;
          Canvas.Brush.Color := WizardForm.Color;
          Canvas.FillRect(Rect);
          DrawIconEx(Canvas.Handle, 0, 0, hIcon, 32, 32, 0, 0, DI_NORMAL);
        end;
        Parent := Page.Surface;
      end;
    finally
      DestroyIcon(hIcon);
    end;
  except
  end;

  Label1 := TNewStaticText.Create(Page);
  with Label1 do begin
    AutoSize := False;
    Left := WizardForm.SelectDirLabel.Left;
    Width := Page.SurfaceWidth - Left;
    WordWrap := True;
    Caption := ALabel1Caption;
    Parent := Page.Surface;
  end;
  WizardForm.AdjustLabelHeight(Label1);

  Label2 := TNewStaticText.Create(Page);
  with Label2 do begin
    Top := Label1.Top + Label1.Height + ScaleY(12);
    Caption := ALabel2Caption;
    Parent := Page.Surface;
  end;
  WizardForm.AdjustLabelHeight(Label2);

  CheckBox := TCheckBox.Create(Page);
  with CheckBox do begin
    Top := Label2.Top + Label2.Height + ScaleY(12);
    Width := Page.SurfaceWidth;
    Caption := ACheckCaption;
    Parent := Page.Surface;
    Checked := false;
  end;

  Result := Page;
end;

// CreateDownloadMYSQLPage - create a Custom Option Page to download MySQL
procedure CreateDownloadMYSQLPage;
var
  Caption, SubCaption1, IconFileName, Label1Caption, Label2Caption, CheckCaption: String;
begin
  Caption := 'MySQL';
  SubCaption1 := 'Would you like to download and install MySQL 5?';
  IconFileName := 'mysql.gif';
  Label1Caption :=
    'MySQL Community Server is the worlds most popular open source database to the open source community' +
    ' and is freely available under the open source GPL license. See http://www.mysql.com for more information.' + #13#10#13#10 +
    'MySQL is required for a full installation of MythTV.';
  Label2Caption := 'Select whether you would like to download and install MySQL, then click Next.';
  CheckCaption := '&Download and install MySQL';

  DownloadMySqlPage := CreateCustomOptionPage(RemoteSQLPage.ID, Caption, SubCaption1, IconFileName, Label1Caption, Label2Caption, CheckCaption, DownloadMySqlCheckBox);
end;
// ------------------------------------------------------------------------------------------
// Initialize Setup - set default parameters
//
// ------------------------------------------------------------------------------------------
function InitializeSetup(): Boolean;
begin
  MySQLPathRead := False;
  Result := True;
  bSQLDetected := False;
  FilesDownloaded := False;
end;


procedure InitializeWizard;
begin
  // Create the page objects
  // First Page - find out if a Frontend or Full installation
  LocalRemotePage := CreateInputOptionPage(wpWelcome,
      'Installation Mode',
       '',
      'MythTv can be installed as a Frontend only, connecting to a remote MythTV backend, or a full installation, providing a combined frontend/backend system. Please specify the installation you want, and press Next.',
      True, False);
  LocalRemotePage.Add('Frontend installation only - requires a MythTV Backend on another machine');
  LocalRemotePage.Add('Full Installation - Combined frontend & backend - requires MySql installation');

  // MySQL.ini parameters - If FrontEnd only
	RemoteSQLPage := CreateInputQueryPage(LocalRemotePage.ID,
	    'Database Information', 'Required information to connect to Backend system',
	    'Please enter the database configuration for your Backend system, and press Next');
    RemoteSQLPage.Add('Backend IP Address or Hostname:', False);
    RemoteSQLPage.Add('Backend Database Username:', False);
    RemoteSQLPage.Add('Backend Database Password:', False);
    RemoteSQLPage.Add('Frontend Hostname (this PC)', False);

  // If Full installation and download of MySQL needed - Create DownloadMySqlPage page
  CreateDownloadMYSQLPage;
  DownloadMySqlCheckBox.Checked := false;

  // If Full installation and configuration of MySQL for MythTV needed
  ConfigureSQL := CreateInputOptionPage(DownloadMySqlPage.ID,
	    'MySQL Configuration', 'Configure MySql for Mythtv',
	    'You have MySQL installed. Do you want to configure MySQL for mythtv? You can answer no and configure it manually, or run configuremysql.vbs from the Mythtv directory after setup',
      True, False);
  ConfigureSQL.Add('Yes');
  ConfigureSQL.Add('No');


  // End Page Objects
  // Set default values, using settings that were stored last time if possible }
   case GetPreviousData('InstallationMode', '') of
    'frontend': LocalRemotePage.SelectedValueIndex := 0;
    'combined': LocalRemotePage.SelectedValueIndex := 1;
  else
    LocalRemotePage.SelectedValueIndex := 0;
  end;

 RemoteSQLPage.Values[0] := GetPreviousData('IPAddress', '');
 RemoteSQLPage.Values[1] := GetPreviousData('DBUsername', 'mythtv');
 RemoteSQLPage.Values[2] := GetPreviousData('DBPassword', 'mythtv');
 RemoteSQLPage.Values[3] := GetPreviousData('Hostname', ExpandConstant('{computername}'));
 ConfigureSQL.SelectedValueIndex := StrToIntDef(GetPreviousData('ConfigureMySQL','1'),1);
end;




procedure RegisterPreviousData(PreviousDataKey: Integer);
var
  InstallationMode: String;
begin
  { Store the settings so we can restore them next time }
  case LocalRemotePage.SelectedValueIndex of
    0:  InstallationMode := 'frontend';
    1:  InstallationMode := 'combined';
  end;
 SetPreviousData(PreviousDataKey, 'InstallationMode', InstallationMode);
 SetPreviousData(PreviousDataKey, 'IPAddress', RemoteSQLPage.Values[0]);
 SetPreviousData(PreviousDataKey, 'DBUsername', RemoteSQLPage.Values[1]);
 SetPreviousData(PreviousDataKey, 'DBPassword', RemoteSQLPage.Values[2]);
 SetPreviousData(PreviousDataKey, 'Hostname', RemoteSQLPage.Values[3]);
 SetPreviousData(PreviousDataKey, 'DwldMySql', IntToStr(Ord(DownloadMySqlCheckBox.Checked)));
 SetPreviousData(PreviousDataKey, 'ConfigureMySQL', IntToStr(Ord(ConfigureSQL.SelectedValueIndex)));

end;

// The wizard calls this event function to determine whether or not a particular page             }
// (specified by PageID) should be shown at all.                                                  }
// If you return True, the page will be skipped; if you return False, the page may be shown.      }
// Note: This event function isn't called for the wpWelcome, wpPreparing, and wpInstalling pages, }
// nor for pages that Setup has already determined should be skipped                              }
// (for example, wpSelectComponents in an install containing no components).                      }
function ShouldSkipPage(PageID: Integer): Boolean;
begin
  // User has selected Full installation - skip page to fillout mysql.txt
  if (PageID = RemoteSQLPage.ID) and (LocalRemotePage.SelectedValueIndex <> 0) then
    Result := True
  // User has selected Frontend only - skip question to download MySql
  else if (PageID = DownloadMySqlPage.ID) and FrontendOnly then
    Result := True
  // User has selected Full installation but SQL is installed
  else if (PageID = DownloadMySqlPage.ID) and MySqlInstalled  then
    Result := True
 // User has selected Frontend only - skip MySql installation page
  else if (PageID = DownloadMySqlPage.ID) and FrontendOnly then
    Result := True
// User has selected Frontend only -  Skip MySQL configuration page
  else if (PageID = ConfigureSQL.ID) and FrontendOnly then
    Result := True
  else if (PageID = wpReady) and InstallMySQL and not FrontendOnly then
    Result := DownloadFiles(DownloadMySqlCheckBox.Checked)
  else
    Result := False;
end;

{Called when the user clicks the Next button.}
{If you return True, the wizard will move to the next page;}
{if you return False, it will remain on the current page (specified by CurPageID)}
{Used to validate entry on page}
function NextButtonClick(CurPageID: Integer): Boolean;
var
  I: Integer;
begin
  // User selected Frontend or Full installation - if Frontend only, nothing to validate
  // If Full, lets find out of MySQL is installed - decision will decide what Screen to show
  if CurPageID = LocalRemotePage.ID then begin
       // If Full installation - find out status of MySQL Installation
       Result := True;
  end else if CurPageID = RemoteSQLPage.ID then begin
    // User is prompted to fill out mysql.txt values for remote server
    // Validate that fields are filled
    if RemoteSQLPage.Values[0] = '' then begin
      MsgBox('You must enter an IP Address or Hostname.', mbError, MB_OK);
      Result := False;
    end else if (RemoteSQLPage.Values[1] = '') then begin
      MsgBox('You must enter a DB username and password.', mbError, MB_OK);
      Result := False;
    end else if (RemoteSQLPage.Values[2] = '') then begin
      MsgBox('You must enter a DB username and password.', mbError, MB_OK);
      Result := False;
    end else
      Result := True;
  end else
    Result := True;
end;
