#! /usr/bin/perl
#* ============================================================
# * File        : wwitv.pl
# * Version     : 0.1
# * Author      : Eric
# * Date        : 2006-09-11
# * Description: parser for http://wwitv.com/portal.htm,
# *              station list frame
# *
# *
# *  
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------


# <a class="rb" href="3.htm" target="r">Algeria
#
#1
#
#</a>

sub dump_lines
{
  # get rid of newlines
  $data =~ s/\n/ /g;
  # multiple spaces
  $data =~ s/\s\s+/ /g;
  # format station links

  while ($data =~ m/<a[^>]+href="([^"]+)"[^>]+>([^<]+)\s+(\d+)\s+<\/a>/gi)
  {
     $item = $doc->createElement('item');
     $root->appendChild($item);
        
     $item->appendChild( newNode('name', "$2 ($3 stations)") );
     $item->appendChild( newNode('url', $1) );
     $item->appendChild( newNode('descr', "select $2") );
     $item->appendChild( newNode('handler', "wwitv/list") );
      
  }
  
}

#------------------------------------------------------------------------------
# search url's in $data and place them in special format
#------------------------------------------------------------------------------

&dump_lines();

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



