#! /usr/bin/perl
#* ============================================================
# * File        : youtube/youvid.pl
# * Version     : 0.1
# * Author      : 
# * Date        : 2006-09-11
# * Description: parser for youtube feed
# *
# * Requires:
# * - mythstream v0.17_2 http 30x (and cookie?) handling
# *
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;
use Data::Dumper;
#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line
$sname = $in[2];

# remove quotes from sname
$sname =~ s/^\"?(.*?)\"?$/$1/;
 

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------




# &dump_lines();

#  <a target="_blank" href="/video/9/8011/12996/78356/110222" onclick="javascript:return doLink('12996/78356/110222');">Part 2</a>
my $a, $b;

if ( @matches = $data =~ /href="(\/video\/[^"]+)"[^>]+>([^<]*)</g )
{
      while ($#matches > 0)
      {
       $a = shift @matches;
       $b = shift @matches;
       
      $url = "http://www.tv-links.co.uk$a";

      $item = $doc->createElement('item');
      $root->appendChild($item);
      
      $item->appendChild( newNode('name', "$sname, $b") );
      $item->appendChild( newNode('url',  $url) );
      $item->appendChild( newNode('descr', "") );
      $item->appendChild( newNode('handler', "tvlinks/video") );
      }
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



