/* ============================================================
 * File  : streamtuned.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2004-02-12
 * Description : streamtuned gui
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef FFT_H
#define FFT_H
 
#include <qwidget.h>
#include <qtimer.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <fftw.h>
#include <stdlib.h>
#include <qthread.h>


struct commArea
{
  int nch;                      /*number of channels*/
  int size;                     /*buffer size*/
  unsigned long long counter;   /*Used to keep sync, it's updated
                                every time new data is exported.*/
};

struct SpectrumValues
{
  int values[100];
};

struct SpectrumQueue
{
  SpectrumValues entry[10];
};


class SampleObject : public QObject
{
  Q_OBJECT

  public:
    SampleObject();
    ~SampleObject();

  signals:
    void sampleReady(commArea* fileBase);

  public slots:
    void checkSamples();

  private:
    QTimer *timer;

    int fd;
    unsigned long long prevCounter;
    struct commArea *fileBase;
    struct stat fileStat;
};

class FFTStarter : public QObject, public QThread
{

  Q_OBJECT

  public:
    FFTStarter();
    virtual void run();

  signals:
    void threadedTrigger();
};

class FFTConverter : public QObject
{
  Q_OBJECT

  public:
    FFTConverter(int numpoints, int numsamples);
    ~FFTConverter();

    void loadSampler(SampleObject *sampler);
    void unloadSampler();

  signals:
    void fftReady(SpectrumValues* fftValues);

  public slots:
    void processSamples(commArea *fileBase);
    void initTrigger();

  private:
    bool          initialized;
    SampleObject *linkedSampler;
    SpectrumQueue fftValues;
    int           fftNumPoints;
    int           sampleWindow;

    // compensating audio buffer (artsd)
    int processIndex; // spectrum queue index to process
    int displayIndex; // signalled spectrum index to display

    FFTW_COMPLEX *in;
    FFTW_COMPLEX *out;
    fftw_plan plan;

    void init();

};
/*
class FFTBox : public QWidget
{
   Q_OBJECT

   public:
     FFTBox(QWidget *parent, int barcnt, unsigned int x, unsigned int y, unsigned int w, unsigned int h);
     ~FFTBox();

     void paintEvent( QPaintEvent * );
     void loadSampler(SampleObject *sampleObject);
     void unloadSampler();

   public slots:
     void setPercentage(SpectrumValues* percent);

   private:
     SpectrumValues *percentage;
     SampleObject *sampler;
     FFTConverter *converter;
     int barCount;
     int barWidth;
     int gaugeWidth;
     float div;
     int textPosX, textPosY;
};


class FFTContainer : public QWidget
{
  Q_OBJECT

  public:
    FFTContainer( QWidget *parent=0, const char *name=0 );
    ~FFTContainer();

  private:
    FFTBox *spectrum;
};

*/

#endif /* FFT_H */
