#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 15:53:27 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon1b_net.py,v 1.2 2009/07/31 00:54:52 vareille Exp $
#
# $Id: cartoon1b_net.py,v 1.2 2009/07/31 00:54:52 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_0 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_0,192,311)
    apply(Show_Image_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_0=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_1 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_1,14,272)
    Scale_1.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_1.inputPortByName['filter'].widget.set(r"NEAREST", run=False)
    apply(Scale_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_1=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_2 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_2,14,216)
    apply(Read_Image_2.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_2.inputPortByName['filename'].rebindWidget()
    Read_Image_2.inputPortByName['filename'].widget.set(r"/home/vareille/dev/Data/crnCartoon0000_movie/crnCartoon0000.png", run=False)
    Read_Image_2.inputPortByName['filename'].unbindWidget()
    apply(Read_Image_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_2=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_3 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_3,14,142)
    apply(iterate_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_3=None

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_5 = Filelist(constrkw={}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_5,14,21)
    Filelist_5.inputPortByName['directory'].widget.set(r"cartoonMovie", run=False)
    Filelist_5.inputPortByName['match_str'].widget.set(r"crnCartoon*png", run=False)
    apply(Filelist_5.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_5=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon1b ##
if Read_Image_2 is not None and Scale_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_2, Scale_1, "image", "image", blocking=True
            , splitratio=[0.56858294828300948, 0.32528461803940639])
    except:
        print "WARNING: failed to restore connection between Read_Image_2 and Scale_1 in network masterNet"
if Scale_1 is not None and Show_Image_0 is not None:
    try:
        masterNet.connectNodes(
            Scale_1, Show_Image_0, "scaledImage", "image", blocking=True
            , splitratio=[0.24029051977687904, 0.24231838495709845])
    except:
        print "WARNING: failed to restore connection between Scale_1 and Show_Image_0 in network masterNet"
if iterate_3 is not None and Read_Image_2 is not None:
    try:
        masterNet.connectNodes(
            iterate_3, Read_Image_2, "oneItem", "filename", blocking=True
            , splitratio=[0.48271968890761402, 0.4106460886354511])
    except:
        print "WARNING: failed to restore connection between iterate_3 and Read_Image_2 in network masterNet"
if Filelist_5 is not None and iterate_3 is not None:
    try:
        masterNet.connectNodes(
            Filelist_5, iterate_3, "filelist", "listToLoopOver", blocking=True
            , splitratio=[0.3090266649604283, 0.46514659118858387])
    except:
        print "WARNING: failed to restore connection between Filelist_5 and iterate_3 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

