########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 13:15:33 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/ViPErPaper-fig1_net.py,v 1.6 2007/10/08 20:20:31 vareille Exp $
#
# $Id: ViPErPaper-fig1_net.py,v 1.6 2007/10/08 20:20:31 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_0 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_0,17,18)
    Read_Molecule_0.inputPortByName['filename'].widget.set("1crn.pdb", run=False)
    apply(Read_Molecule_0.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_0=None

try:
    ## saving node Assign Radii ##
    from MolKit.VisionInterface.MolKitNodes import AssignRadii
    Assign_Radii_1 = AssignRadii(constrkw = {}, name='Assign Radii', library=molkitlib)
    masterNet.addNode(Assign_Radii_1,17,119)
    Assign_Radii_1.inputPortByName['united'].widget.set(1, run=False)
    apply(Assign_Radii_1.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AssignRadii named Assign Radii in network masterNet"
    print_exc()
    Assign_Radii_1=None

try:
    ## saving node MSMS ##
    from MolKit.VisionInterface.MolKitNodes import AtomsAsMSMS
    MSMS_2 = AtomsAsMSMS(constrkw = {}, name='MSMS', library=molkitlib)
    masterNet.addNode(MSMS_2,185,244)
    MSMS_2.inputPortByName['density'].widget.set(5.0, run=False)
except:
    print "WARNING: failed to restore AtomsAsMSMS named MSMS in network masterNet"
    print_exc()
    MSMS_2=None

try:
    ## saving node Select Nodes ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_Nodes_3 = NodeSelector(constrkw = {}, name='Select Nodes', library=molkitlib)
    masterNet.addNode(Select_Nodes_3,309,34)
    apply(Select_Nodes_3.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore NodeSelector named Select Nodes in network masterNet"
    print_exc()
    Select_Nodes_3=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_4 = AtomsProperty(constrkw = {}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_4,385,160)
    Extract_Atom_Property_4.inputPortByName['propertyName'].widget.set("radius", run=False)
    apply(Extract_Atom_Property_4.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_4=None

try:
    ## saving node MSMS triang. ##
    from MolKit.VisionInterface.MolKitNodes import GetMSMStriangles
    MSMS_triang__5 = GetMSMStriangles(constrkw = {}, name='MSMS triang.', library=molkitlib)
    masterNet.addNode(MSMS_triang__5,24,327)
    apply(MSMS_triang__5.inputPortByName['component'].widget.configure, (), {'max': 0})
except:
    print "WARNING: failed to restore GetMSMStriangles named MSMS triang. in network masterNet"
    print_exc()
    MSMS_triang__5=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_6 = IndexedPolygonsNE(constrkw = {}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_6,24,385)
    indexedPolygons_6.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_6=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_7 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_7,159,457)
    ##
    ## Saving State for Viewer
    Viewer_7.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 2027, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.44446169579464, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -68.846794128417969], 'd2cutH': 255, 'far': 164.28732092573586, 'd1off': 4, 'lookFrom': [0.0, 0.0, 68.846794128417969], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 6.6827440655610353, 'drawThumbnail': False, 'rooty': 76, 'd1scale': 0.012999999999999999}
    apply(Viewer_7.vi.cameras[0].Set, (), state)

    state = {'end': 96.787376921190216, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 45.675811126887886, 'mode': 'GL_LINEAR'}
    apply(Viewer_7.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    state = {'scale': [1.4353848583409141, 1.4353848583409141, 1.4353848583409141], 'name': 'ClipPlane0', 'color': [1.0, 1.0, 1.0, 1.0], 'enabled': False, 'visible': 0, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.6259925365447998, -0.36297792196273804, 0.69020324945449829, 0.0, -0.24739572405815125, -0.74691444635391235, -0.61718243360519409, 0.0, 0.73954635858535767, -0.55710494518280029, 0.37776368856430054, 0.0, 0.0, 0.0, 0.0, 1.0], 'lineWidth': 2, 'translation': [10.765459060668945, 11.429803848266602, 0.0]}
    apply(Viewer_7.vi.clipP[0].Set, (), state)

    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [10.136495590209961, 9.8463525772094727, 6.5075764656066895], 'rotation': [0.94336473941802979, 0.32135313749313354, 0.082432940602302551, 0.0, 0.32222169637680054, -0.94665974378585815, 0.002905137138441205, 0.0, 0.078969523310661316, 0.023821080103516579, -0.99659246206283569, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-10.268986701965332, -9.143153190612793, -5.8339605331420898], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Viewer_7.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_7.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_7.vi.rootObject:
        Viewer_7.vi.rootObject.clipP = []
        Viewer_7.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_7=None

try:
    ## saving node Array Ufunc2 ##
    from Vision.StandardNodes import BinaryFuncs
    Array_Ufunc2_8 = BinaryFuncs(constrkw = {}, name='Array Ufunc2', library=stdlib)
    masterNet.addNode(Array_Ufunc2_8,385,277)
    apply(Array_Ufunc2_8.inputPortByName['inArrayList1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    apply(Array_Ufunc2_8.inputPortByName['inArrayList2'].configure, (), {'datatype': 'float', 'originalDatatype': 'None'})
    Array_Ufunc2_8.inputPortByName['operator'].widget.set("multiply", run=False)
    apply(Array_Ufunc2_8.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore BinaryFuncs named Array Ufunc2 in network masterNet"
    print_exc()
    Array_Ufunc2_8=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_9 = DialNE(constrkw = {}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_9,618,147)
    Dial_9.inputPortByName['dial'].widget.set(0.66, run=False)
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_9=None

try:
    ## saving node Extract Atom Property ##
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_10 = AtomsProperty(constrkw = {}, name='Extract Atom Property', library=molkitlib)
    masterNet.addNode(Extract_Atom_Property_10,672,275)
    Extract_Atom_Property_10.inputPortByName['propertyName'].widget.set("coords[0]", run=False)
    apply(Extract_Atom_Property_10.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore AtomsProperty named Extract Atom Property in network masterNet"
    print_exc()
    Extract_Atom_Property_10=None

try:
    ## saving node Grab Image ##
    from Vision.PILNodes import GetFrontBuffer
    Grab_Image_11 = GetFrontBuffer(constrkw = {}, name='Grab Image', library=imagelib)
    masterNet.addNode(Grab_Image_11,16,517)
except:
    print "WARNING: failed to restore GetFrontBuffer named Grab Image in network masterNet"
    print_exc()
    Grab_Image_11=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_12 = ResizeImage(constrkw = {}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_12,16,575)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_12=None

try:
    ## saving node Filter Image ##
    from Vision.PILNodes import ImageFilter
    Filter_Image_13 = ImageFilter(constrkw = {}, name='Filter Image', library=imagelib)
    masterNet.addNode(Filter_Image_13,16,633)
    Filter_Image_13.inputPortByName['filter'].widget.set("CONTOUR", run=False)
    apply(Filter_Image_13.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ImageFilter named Filter Image in network masterNet"
    print_exc()
    Filter_Image_13=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_14 = ShowImage(constrkw = {}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_14,16,725)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_14=None

try:
    ## saving node CPK ##
    from MolKit.VisionInterface.MolKitNodes import AtomsAsCPK
    CPK_15 = AtomsAsCPK(constrkw = {}, name='CPK', library=molkitlib)
    masterNet.addNode(CPK_15,283,386)
    CPK_15.inputPortByName['quality'].widget.set(16, run=False)
    CPK_15.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore AtomsAsCPK named CPK in network masterNet"
    print_exc()
    CPK_15=None

try:
    ## saving node Color Map ##
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_16 = ColorMapNE(constrkw = {}, name='Color Map', library=vizlib)
    masterNet.addNode(Color_Map_16,551,395)
except:
    print "WARNING: failed to restore ColorMapNE named Color Map in network masterNet"
    print_exc()
    Color_Map_16=None

masterNet.run()
masterNet.freeze()

## saving connections for network ViPErPaper-fig1 ##
if Read_Molecule_0 is not None and Assign_Radii_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, Assign_Radii_1, "MolSets", "molecules", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and Assign_Radii_1 in network masterNet"
if Assign_Radii_1 is not None and Select_Nodes_3 is not None:
    try:
        masterNet.connectNodes(
            Assign_Radii_1, Select_Nodes_3, "molecules", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between Assign_Radii_1 and Select_Nodes_3 in network masterNet"
if Select_Nodes_3 is not None and MSMS_2 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, MSMS_2, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and MSMS_2 in network masterNet"
if Select_Nodes_3 is not None and Extract_Atom_Property_4 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, Extract_Atom_Property_4, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and Extract_Atom_Property_4 in network masterNet"
if Extract_Atom_Property_4 is not None and MSMS_2 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_4, MSMS_2, "propertyValues", "radii", blocking=True)
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_4 and MSMS_2 in network masterNet"
if MSMS_2 is not None and MSMS_triang__5 is not None:
    try:
        masterNet.connectNodes(
            MSMS_2, MSMS_triang__5, "MSMS", "MSMS", blocking=True)
    except:
        print "WARNING: failed to restore connection between MSMS_2 and MSMS_triang__5 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "vertices", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if MSMS_triang__5 is not None and indexedPolygons_6 is not None:
    try:
        masterNet.connectNodes(
            MSMS_triang__5, indexedPolygons_6, "vnormals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between MSMS_triang__5 and indexedPolygons_6 in network masterNet"
if indexedPolygons_6 is not None and Viewer_7 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_6, Viewer_7, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indexedPolygons_6 and Viewer_7 in network masterNet"
if Extract_Atom_Property_4 is not None and Array_Ufunc2_8 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_4, Array_Ufunc2_8, "propertyValues", "inArrayList1", blocking=True)
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_4 and Array_Ufunc2_8 in network masterNet"
if Dial_9 is not None and Array_Ufunc2_8 is not None:
    try:
        masterNet.connectNodes(
            Dial_9, Array_Ufunc2_8, "value", "inArrayList2", blocking=True)
    except:
        print "WARNING: failed to restore connection between Dial_9 and Array_Ufunc2_8 in network masterNet"
if Select_Nodes_3 is not None and Extract_Atom_Property_10 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, Extract_Atom_Property_10, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and Extract_Atom_Property_10 in network masterNet"
if Viewer_7 is not None and Grab_Image_11 is not None:
    try:
        masterNet.connectNodes(
            Viewer_7, Grab_Image_11, "dejaVuViewer", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Viewer_7 and Grab_Image_11 in network masterNet"
if Grab_Image_11 is not None and Scale_12 is not None:
    try:
        masterNet.connectNodes(
            Grab_Image_11, Scale_12, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grab_Image_11 and Scale_12 in network masterNet"
if Scale_12 is not None and Filter_Image_13 is not None:
    try:
        masterNet.connectNodes(
            Scale_12, Filter_Image_13, "scaledImage", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Scale_12 and Filter_Image_13 in network masterNet"
if Filter_Image_13 is not None and Show_Image_14 is not None:
    try:
        masterNet.connectNodes(
            Filter_Image_13, Show_Image_14, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filter_Image_13 and Show_Image_14 in network masterNet"
if Color_Map_16 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Color_Map_16, CPK_15, "mappedColors", "colors", blocking=True)
    except:
        print "WARNING: failed to restore connection between Color_Map_16 and CPK_15 in network masterNet"
if Extract_Atom_Property_10 is not None and Color_Map_16 is not None:
    try:
        masterNet.connectNodes(
            Extract_Atom_Property_10, Color_Map_16, "propertyValues", "values", blocking=True)
    except:
        print "WARNING: failed to restore connection between Extract_Atom_Property_10 and Color_Map_16 in network masterNet"
if Array_Ufunc2_8 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Array_Ufunc2_8, CPK_15, "outArrayList", "radii", blocking=True)
    except:
        print "WARNING: failed to restore connection between Array_Ufunc2_8 and CPK_15 in network masterNet"
if Select_Nodes_3 is not None and CPK_15 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_3, CPK_15, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_3 and CPK_15 in network masterNet"
if CPK_15 is not None and Viewer_7 is not None:
    try:
        masterNet.connectNodes(
            CPK_15, Viewer_7, "CPK", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between CPK_15 and Viewer_7 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_7(self=Viewer_7, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|indexedPolygons
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'indexedPolygons', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|indexedPolygons')
    if obj:
        apply(obj.Set, (), state)

    ## Material for indexedPolygons
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.6538461446762085], 'binding': [10.0, 10, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.033794164657592773, 0.68117016553878784, 1.0, 0.6538461446762085]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.11225049942731857, 0.4822641909122467, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_BACK].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for indexedPolygons

    ## Clipping Planes for indexedPolygons
    if obj:
        obj.clipP = []
        obj.clipPI = []
        clip = obj.viewer.clipP[0]
        obj.AddClipPlane(clip, obj.clipSide[clip.num], False)
        pass  ## needed in case there no modif
    ## End Clipping Planes for indexedPolygons

    ## Object root|CPK
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'CPK', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|CPK')
    if obj:
        apply(obj.Set, (), state)

    ## Material for CPK
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 11.0, 10.0, 10.0, 10.0, 11.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for CPK

    ## Clipping Planes for CPK
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for CPK

    ## End Object root|CPK

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.44446169579464, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -68.846794128417969], 'd2cutH': 255, 'far': 164.28732092573586, 'd1off': 4, 'lookFrom': [0.0, 0.0, 68.846794128417969], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 6.6827440655610353, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 96.787376921190216, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 45.675811126887886, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    state = {'scale': [1.4353848583409141, 1.4353848583409141, 1.4353848583409141], 'name': 'ClipPlane0', 'color': [1.0, 1.0, 1.0, 1.0], 'enabled': False, 'visible': 0, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.6259925365447998, -0.36297792196273804, 0.69020324945449829, 0.0, -0.24739572405815125, -0.74691444635391235, -0.61718243360519409, 0.0, 0.73954635858535767, -0.55710494518280029, 0.37776368856430054, 0.0, 0.0, 0.0, 0.0, 1.0], 'lineWidth': 2, 'translation': [10.765459060668945, 11.429803848266602, 0.0]}
    apply(self.vi.clipP[0].Set, (), state)

    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [10.136495590209961, 9.8463525772094727, 6.5075764656066895], 'rotation': [0.94336473941802979, 0.32135313749313354, 0.082432940602302551, 0.0, 0.32222169637680054, -0.94665974378585815, 0.002905137138441205, 0.0, 0.078969523310661316, 0.023821080103516579, -0.99659246206283569, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-10.268986701965332, -9.143153190612793, -5.8339605331420898], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_7.restoreStates_cb = Viewer_7.restoreStatesFirstRun = loadSavedStates_Viewer_7
Viewer_7.menu.add_separator()
Viewer_7.menu.add_command(label='Restore states', command=Viewer_7.restoreStates_cb)

#masterNet.run()
