#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 06 August 2008 16:01:15 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#

from traceback import print_exc

## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

    masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_0 = NodeSelector(constrkw={}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_0,118,214)
    Select_MolFrag_0.inputPortByName['nodeType'].widget.set("Atom", run=False)
    Select_MolFrag_0.inputPortByName['selectionString'].widget.set("", run=False)
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_0=None

try:
    ## saving node setattr ##
    from Vision.StandardNodes import SetAttr
    setattr_1 = SetAttr(constrkw={}, name='setattr', library=stdlib)
    masterNet.addNode(setattr_1,5,293)
    apply(setattr_1.configure, (), {'specialPortsVisible': True})
    setattr_1.inputPortByName['name'].rebindWidget()
    setattr_1.inputPortByName['name'].widget.set("myattribut", run=False)
    setattr_1.inputPortByName['name'].unbindWidget()
    apply(setattr_1.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore SetAttr named setattr in network masterNet"
    print_exc()
    setattr_1=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_2 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_2,320,29)
    Choose_Cmd_2.inputPortByName['cmdName'].widget.set("computeMSMS", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_2=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_3 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_3,411,0)
    Pmv_3.inputPortByName['cmdName'].widget.set("", run=False)
    Pmv_3.inputPortByName['molecule'].widget.set("", run=False)
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_3=None

try:
    ## saving node Run computeMSMS ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_computeMSMS_4 = PmvRunCommand(sortedArgNames=['hdensity', 'hdset', 'topCommand', 'setupUndo', 'surfName', 'density', 'log', 'perMol', 'redraw', 'display', 'pRadius'], command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'topCommand': True, 'setupUndo': True, 'surfName': 'MSMS-MOL', 'density': 3.0, 'log': True, 'perMol': True, 'redraw': True, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'sortedArgNames': "['hdensity', 'hdset', 'topCommand', 'setupUndo', 'surfName', 'density', 'log', 'perMol', 'redraw', 'display', 'pRadius']", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': "{'hdensity': 6.0, 'hdset': 'None', 'topCommand': True, 'setupUndo': True, 'surfName': 'MSMS-MOL', 'density': 3.0, 'log': True, 'perMol': True, 'redraw': True, 'display': True, 'pRadius': 1.5}", 'posArgsNames': "['nodes']"}, name='Run computeMSMS', library=pmvlib)
    masterNet.addNode(Run_computeMSMS_4,244,103)
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'Molecule', 'required': True, 'height': 12, 'width': 8, 'shape': 'oval', 'color': '#c64e70'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'hdensity', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to6.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'hdset', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'surfName', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toMSMS-MOL', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'density', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to3.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'perMol', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'display', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'pRadius', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to1.5', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    Run_computeMSMS_4.inputPortByName['importString'].widget.set("", run=False)
    apply(Run_computeMSMS_4.inputPortByName['hdensity'].createWidget, (), {'descr':{'initialValue': 6.0, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'hdensity'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_4.inputPortByName['hdensity'].widget.set(6.0, run=False)
    apply(Run_computeMSMS_4.inputPortByName['hdset'].createWidget, (), {'descr':{'initialValue': 'None', 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 3}, 'labelCfg': {'text': 'hdset'}, 'class': 'NEEntry'}})
    Run_computeMSMS_4.inputPortByName['hdset'].widget.set("None", run=False)
    apply(Run_computeMSMS_4.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['surfName'].createWidget, (), {'descr':{'initialValue': 'MSMS-MOL', 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 9}, 'labelCfg': {'text': 'surfName'}, 'class': 'NEEntry'}})
    Run_computeMSMS_4.inputPortByName['surfName'].widget.set("MSMS-MOL", run=False)
    apply(Run_computeMSMS_4.inputPortByName['density'].createWidget, (), {'descr':{'initialValue': 3.0, 'labelGridCfg': {'column': 0, 'row': 11, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 11}, 'labelCfg': {'text': 'density'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_4.inputPortByName['density'].widget.set(3.0, run=False)
    apply(Run_computeMSMS_4.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 13, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 13}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['perMol'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 15, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 15}, 'labelCfg': {'text': 'perMol'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['perMol'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 17, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 17}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['redraw'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['display'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 19, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 19}, 'labelCfg': {'text': 'display'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['display'].widget.set(1, run=False)
    apply(Run_computeMSMS_4.inputPortByName['pRadius'].createWidget, (), {'descr':{'initialValue': 1.5, 'labelGridCfg': {'column': 0, 'row': 21, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 21}, 'labelCfg': {'text': 'pRadius'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_4.inputPortByName['pRadius'].widget.set(1.5, run=False)
except:
    print "WARNING: failed to restore PmvRunCommand named Run computeMSMS in network masterNet"
    print_exc()
    Run_computeMSMS_4=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_5 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_5,411,132)
    Choose_Cmd_5.inputPortByName['cmdName'].widget.set("colorByProperty", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_5=None

try:
    ## saving node myattribut ##
    from Vision.StandardNodes import Eval
    myattribut_6 = Eval(constrkw={}, name='myattribut', library=stdlib)
    masterNet.addNode(myattribut_6,55,214)
    myattribut_6.inputPortByName['command'].widget.set("'myattribut'", run=False)
    myattribut_6.inputPortByName['importString'].widget.set("", run=False)
except:
    print "WARNING: failed to restore Eval named myattribut in network masterNet"
    print_exc()
    myattribut_6=None

try:
    ## saving node [MSMS-MOL,st... ##
    from Vision.StandardNodes import Eval
    _MSMS_MOL_st____7 = Eval(constrkw={}, name='[MSMS-MOL,st...', library=stdlib)
    masterNet.addNode(_MSMS_MOL_st____7,430,172)
    _MSMS_MOL_st____7.inputPortByName['command'].widget.set("['MSMS-MOL','sticks','balls']", run=False)
    _MSMS_MOL_st____7.inputPortByName['importString'].widget.set("", run=False)
except:
    print "WARNING: failed to restore Eval named [MSMS-MOL,st... in network masterNet"
    print_exc()
    _MSMS_MOL_st____7=None

try:
    ## saving node Atom ##
    from Vision.StandardNodes import Eval
    Atom_8 = Eval(constrkw={}, name='Atom', library=stdlib)
    masterNet.addNode(Atom_8,443,264)
    Atom_8.inputPortByName['command'].widget.set("'Atom'", run=False)
    Atom_8.inputPortByName['importString'].widget.set("", run=False)
except:
    print "WARNING: failed to restore Eval named Atom in network masterNet"
    print_exc()
    Atom_8=None

try:
    ## saving node Run displaySticksAndBalls ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_displaySticksAndBalls_9 = PmvRunCommand(sortedArgNames=['topCommand', 'setupUndo', 'log', 'cquality', 'sticksBallsLicorice', 'bquality', 'cradius', 'only', 'bRad', 'negate', 'bScale', 'redraw'], command=masterNet.editor.vf.displaySticksAndBalls, namedArgs={'topCommand': True, 'setupUndo': True, 'log': True, 'cquality': 0, 'sticksBallsLicorice': 'Sticks and Balls', 'bquality': 0, 'cradius': 0.20000000000000001, 'only': False, 'bRad': 0.29999999999999999, 'negate': False, 'bScale': 0.0, 'redraw': True}, posArgsNames=['nodes'], constrkw={'sortedArgNames': "['topCommand', 'setupUndo', 'log', 'cquality', 'sticksBallsLicorice', 'bquality', 'cradius', 'only', 'bRad', 'negate', 'bScale', 'redraw']", 'command': 'masterNet.editor.vf.displaySticksAndBalls', 'namedArgs': "{'topCommand': True, 'setupUndo': True, 'log': True, 'cquality': 0, 'sticksBallsLicorice': 'Sticks and Balls', 'bquality': 0, 'cradius': 0.20000000000000001, 'only': False, 'bRad': 0.29999999999999999, 'negate': False, 'bScale': 0.0, 'redraw': True}", 'posArgsNames': "['nodes']"}, name='Run displaySticksAndBalls', library=pmvlib)
    masterNet.addNode(Run_displaySticksAndBalls_9,203,215)
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'Molecule', 'required': True, 'height': 12, 'width': 8, 'shape': 'oval', 'color': '#c64e70'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'cquality', 'cast': True, 'datatype': 'int', 'balloon': 'Defaults to0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'sticksBallsLicorice', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toSticks and Balls', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'bquality', 'cast': True, 'datatype': 'int', 'balloon': 'Defaults to0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'cradius', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to0.2', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'only', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toFalse', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'bRad', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to0.3', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'negate', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toFalse', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'bScale', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to0.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_displaySticksAndBalls_9.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    Run_displaySticksAndBalls_9.inputPortByName['importString'].widget.set("", run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['cquality'].createWidget, (), {'descr':{'initialValue': 0, 'type': 'int', 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'cquality'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_displaySticksAndBalls_9.inputPortByName['cquality'].widget.set(0, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['sticksBallsLicorice'].createWidget, (), {'descr':{'initialValue': 'Sticks and Balls', 'labelGridCfg': {'column': 0, 'sticky': 'w', 'row': 9}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 9}, 'labelCfg': {'text': 'sticksBallsLicorice'}, 'class': 'NEEntry'}})
    Run_displaySticksAndBalls_9.inputPortByName['sticksBallsLicorice'].widget.set("Licorice", run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['bquality'].createWidget, (), {'descr':{'initialValue': 0, 'type': 'int', 'labelGridCfg': {'column': 0, 'row': 11, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 11}, 'labelCfg': {'text': 'bquality'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_displaySticksAndBalls_9.inputPortByName['bquality'].widget.set(0, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['cradius'].createWidget, (), {'descr':{'initialValue': 0.20000000000000001, 'labelGridCfg': {'column': 0, 'row': 13, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 13}, 'labelCfg': {'text': 'cradius'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_displaySticksAndBalls_9.inputPortByName['cradius'].widget.set(0.2, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['only'].createWidget, (), {'descr':{'initialValue': False, 'labelGridCfg': {'column': 0, 'row': 15, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 15}, 'labelCfg': {'text': 'only'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['only'].widget.set(0, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['bRad'].createWidget, (), {'descr':{'initialValue': 0.29999999999999999, 'labelGridCfg': {'column': 0, 'row': 17, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 17}, 'labelCfg': {'text': 'bRad'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_displaySticksAndBalls_9.inputPortByName['bRad'].widget.set(0.3, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['negate'].createWidget, (), {'descr':{'initialValue': False, 'labelGridCfg': {'column': 0, 'row': 19, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 19}, 'labelCfg': {'text': 'negate'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['negate'].widget.set(0, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['bScale'].createWidget, (), {'descr':{'initialValue': 0.0, 'labelGridCfg': {'column': 0, 'row': 21, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 21}, 'labelCfg': {'text': 'bScale'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_displaySticksAndBalls_9.inputPortByName['bScale'].widget.set(0.0, run=False)
    apply(Run_displaySticksAndBalls_9.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 23, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 23}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_displaySticksAndBalls_9.inputPortByName['redraw'].widget.set(1, run=False)
except:
    print "WARNING: failed to restore PmvRunCommand named Run displaySticksAndBalls in network masterNet"
    print_exc()
    Run_displaySticksAndBalls_9=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_10 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_10,344,150)
    Choose_Cmd_10.inputPortByName['cmdName'].widget.set("displaySticksAndBalls", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_10=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_11 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw={'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_11,517,18)
    ##
        ## Saving State for Viewer
    Pmv_Viewer_11.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 27, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 24.21651176056633, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -32.095829], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 32.095829], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 126, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_11.vi.cameras[0].Set, (), state)

    state = {'end': 40.6337953575147, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 23.557865694994181, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_11.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [2.8689413, 6.2097216, -6.4630127], 'rotation': [-0.39943755, -0.13025042, 0.90746051, 0.0, 0.12423894, -0.98841476, -0.087183677, 0.0, 0.90830308, 0.077917494, 0.41099215, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-2.4972451, -6.9970546, 6.4630122], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Pmv_Viewer_11.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_11.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_11.vi.rootObject:
        Pmv_Viewer_11.vi.rootObject.clipP = []
        Pmv_Viewer_11.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_11=None

try:
    ## saving node Run colorByProperty ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_colorByProperty_12 = PmvRunCommand(sortedArgNames=['mini', 'topCommand', 'setupUndo', 'colormap', 'propertyLevel', 'maxi', 'redraw', 'log'], command=masterNet.editor.vf.colorByProperty, namedArgs={'mini': None, 'topCommand': True, 'setupUndo': True, 'colormap': 'rgb256', 'propertyLevel': None, 'maxi': None, 'redraw': True, 'log': True}, posArgsNames=['nodes', 'geomsToColor', 'property'], constrkw={'sortedArgNames': "['mini', 'topCommand', 'setupUndo', 'colormap', 'propertyLevel', 'maxi', 'redraw', 'log']", 'command': 'masterNet.editor.vf.colorByProperty', 'namedArgs': "{'mini': None, 'topCommand': True, 'setupUndo': True, 'colormap': 'rgb256', 'propertyLevel': None, 'maxi': None, 'redraw': True, 'log': True}", 'posArgsNames': "['nodes', 'geomsToColor', 'property']"}, name='Run colorByProperty', library=pmvlib)
    masterNet.addNode(Run_colorByProperty_12,274,303)
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'AtomSet', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': '#fe92a0'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'geomsToColor', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'property', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'mini', 'cast': True, 'datatype': 'None', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'colormap', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults torgb256', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'propertyLevel', 'cast': True, 'datatype': 'None', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'maxi', 'cast': True, 'datatype': 'None', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_colorByProperty_12.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_colorByProperty_12.configure, (), {'specialPortsVisible': True})
    Run_colorByProperty_12.inputPortByName['importString'].widget.set("", run=False)
    apply(Run_colorByProperty_12.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_colorByProperty_12.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_colorByProperty_12.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_colorByProperty_12.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_colorByProperty_12.inputPortByName['colormap'].createWidget, (), {'descr':{'initialValue': 'rgb256', 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 5}, 'labelCfg': {'text': 'colormap'}, 'class': 'NEEntry'}})
    Run_colorByProperty_12.inputPortByName['colormap'].widget.set("rgb256", run=False)
    apply(Run_colorByProperty_12.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_colorByProperty_12.inputPortByName['redraw'].widget.set(1, run=False)
    apply(Run_colorByProperty_12.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 9}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_colorByProperty_12.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_colorByProperty_12.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named Run colorByProperty in network masterNet"
    print_exc()
    Run_colorByProperty_12=None

try:
    ## saving node Get parser.filename ##
    from Vision.StandardNodes import GetAttr
    Get_parser_filename_13 = GetAttr(constrkw={}, name='Get parser.filename', library=stdlib)
    masterNet.addNode(Get_parser_filename_13,5,21)
    apply(Get_parser_filename_13.inputPortByName['attr'].widget.configure, (), {'choices': ['AAradii', 'APBSParams', 'AtomRadiiPatterns', 'NodesFromName', '_ExtrudeSecondaryStructureCommand__hasSSGeom', '_MarkTree', '__cmp__', '__doc__', '__eq__', '__hash__', '__init__', '__module__', '__ne__', '__repr__', '__str__', '_atomRadius', '_copyNode', '_copy_atom_attr', '_fit_atom_into_tree', '_numberOfDeletedNodes', '_uniqIndex', 'addBond', 'adopt', 'allAtoms', 'assignUniqIndex', 'atmNum', 'attach_nonbonded_fragments', 'bonds', 'bondsflag', 'buildBondsBhtree', 'buildBondsByDistance', 'buildBondsByDistanceOnAtoms', 'buildBrokenBonds', 'chains', 'childByName', 'children', 'childrenName', 'childrenSetClass', 'closerThan', 'compare', 'compiled_patterns', 'configureProgressBar', 'copy', 'defaultRadii', 'deleteSubTree', 'dump', 'elementType', 'findLevels', 'findType', 'full_name', 'geomContainer', 'geomName', 'get', 'getAtoms', 'getCenter', 'getNbrAtoms', 'getNext', 'getParentOfType', 'getPrevious', 'getRoot', 'getTypeList', 'hasBonds', 'hasSS', 'isAbove', 'isBelow', 'levels', 'makeNameUniq', 'merge', 'mergeNPH', 'name', 'number', 'p', 'parent', 'parser', 'read', 'remove', 'removeAllHydrogens', 'removeBond', 'secondaryStructure', 'secondaryStructureFromFile', 'secondaryStructureFromStride', 'setClass', 'split', 'subTree', 'top', 'unitedRadii', 'updateProgressBar', 'write']})
    Get_parser_filename_13.inputPortByName['attr'].widget.set("parser.filename", run=False)
except:
    print "WARNING: failed to restore GetAttr named Get parser.filename in network masterNet"
    print_exc()
    Get_parser_filename_13=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_14 = ReadTable(constrkw={}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_14,5,127)
    ReadTable_14.inputPortByName['filename'].rebindWidget()
    ReadTable_14.inputPortByName['filename'].widget.set("", run=False)
    ReadTable_14.inputPortByName['filename'].unbindWidget()
    ReadTable_14.inputPortByName['numOfTopLinesToJump'].widget.set(0, run=False)
    ReadTable_14.inputPortByName['numOfBottomLinesToJump'].widget.set(0, run=False)
    ReadTable_14.inputPortByName['sep'].widget.set("", run=False)
    ReadTable_14.inputPortByName['datatype'].widget.set("str", run=False)
    ReadTable_14.inputPortByName['numpyIndices'].widget.set("[ : , : ]", run=False)
    apply(ReadTable_14.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_14=None

try:
    ## saving node Generic ##
    from Vision.StandardNodes import Generic
    Generic_15 = Generic(constrkw={}, name='Generic', library=stdlib)
    masterNet.addNode(Generic_15,5,180)
    apply(Generic_15.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Generic_15.addOutputPort, (), {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, in0):
    from string import  atof
    data = []
    for line in in0:
        data.append(atof(line[9]) + atof(line[10]))
    self.outputData(out0=data)



"""
    Generic_15.configure(function=code)
    apply(Generic_15.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Generic named Generic in network masterNet"
    print_exc()
    Generic_15=None

try:
    ## saving node ind_docked ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'ind_docked.pdbq'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    ind_docked_16 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("ind_docked")[0], constrkw={'molecule': 'masterNet.editor.vf.expandNodes("ind_docked")[0]'}, name='ind_docked', library=pmvlib)
    masterNet.addNode(ind_docked_16,159,12)
except:
    print "WARNING: failed to restore PmvMolecule named ind_docked in network masterNet"
    print_exc()
    ind_docked_16=None

try:
    ## saving node os.path.split(i... ##
    from Vision.StandardNodes import Eval
    os_path_split_i____17 = Eval(constrkw={}, name='os.path.split(i...', library=stdlib)
    masterNet.addNode(os_path_split_i____17,5,74)
    apply(os_path_split_i____17.inputPortByName['in1'].configure, (), {'datatype': 'list', 'required': True, 'originalDatatype': 'None'})
    os_path_split_i____17.inputPortByName['command'].widget.set("os.path.split(in1[0])[-1]", run=False)
    os_path_split_i____17.inputPortByName['importString'].widget.set("", run=False)
except:
    print "WARNING: failed to restore Eval named os.path.split(i... in network masterNet"
    print_exc()
    os_path_split_i____17=None

#masterNet.run()
masterNet.freeze()

## saving connections for network msmsGen ##
if Select_MolFrag_0 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, setattr_1, "nodes", "object", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and setattr_1 in network masterNet"
if Pmv_3 is not None and Choose_Cmd_2 is not None:
    try:
        masterNet.connectNodes(
            Pmv_3, Choose_Cmd_2, "PMV", "viewer", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Pmv_3 and Choose_Cmd_2 in network masterNet"
if Choose_Cmd_2 is not None and Run_computeMSMS_4 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_2, Run_computeMSMS_4, "cmd", "command", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_2 and Run_computeMSMS_4 in network masterNet"
if Pmv_3 is not None and Choose_Cmd_5 is not None:
    try:
        masterNet.connectNodes(
            Pmv_3, Choose_Cmd_5, "PMV", "viewer", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Pmv_3 and Choose_Cmd_5 in network masterNet"
if Pmv_3 is not None and Choose_Cmd_10 is not None:
    try:
        masterNet.connectNodes(
            Pmv_3, Choose_Cmd_10, "PMV", "viewer", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Pmv_3 and Choose_Cmd_10 in network masterNet"
if Choose_Cmd_10 is not None and Run_displaySticksAndBalls_9 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_10, Run_displaySticksAndBalls_9, "cmd", "command", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_10 and Run_displaySticksAndBalls_9 in network masterNet"
if Choose_Cmd_5 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_5, Run_colorByProperty_12, "cmd", "command", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_5 and Run_colorByProperty_12 in network masterNet"
if Select_MolFrag_0 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, Run_colorByProperty_12, "nodes", "nodes", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and Run_colorByProperty_12 in network masterNet"
if _MSMS_MOL_st____7 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.connectNodes(
            _MSMS_MOL_st____7, Run_colorByProperty_12, "result", "geomsToColor", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between _MSMS_MOL_st____7 and Run_colorByProperty_12 in network masterNet"
if myattribut_6 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.connectNodes(
            myattribut_6, Run_colorByProperty_12, "result", "property", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between myattribut_6 and Run_colorByProperty_12 in network masterNet"
if Atom_8 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.connectNodes(
            Atom_8, Run_colorByProperty_12, "result", "propertyLevel", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Atom_8 and Run_colorByProperty_12 in network masterNet"
if setattr_1 is not None and Run_colorByProperty_12 is not None:
    try:
        masterNet.specialConnectNodes(
            setattr_1, Run_colorByProperty_12, "trigger", "runNode", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between setattr_1 and Run_colorByProperty_12 in network masterNet"
if ReadTable_14 is not None and Generic_15 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_14, Generic_15, "data", "in0", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ReadTable_14 and Generic_15 in network masterNet"
if Generic_15 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            Generic_15, setattr_1, "out0", "value", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Generic_15 and setattr_1 in network masterNet"
if ind_docked_16 is not None and Run_computeMSMS_4 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_16, Run_computeMSMS_4, "Molecule", "nodes", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ind_docked_16 and Run_computeMSMS_4 in network masterNet"
if ind_docked_16 is not None and Run_displaySticksAndBalls_9 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_16, Run_displaySticksAndBalls_9, "Molecule", "nodes", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ind_docked_16 and Run_displaySticksAndBalls_9 in network masterNet"
if ind_docked_16 is not None and Select_MolFrag_0 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_16, Select_MolFrag_0, "Molecule", "nodes", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ind_docked_16 and Select_MolFrag_0 in network masterNet"
if ind_docked_16 is not None and Get_parser_filename_13 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_16, Get_parser_filename_13, "Molecule", "objects", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ind_docked_16 and Get_parser_filename_13 in network masterNet"
if myattribut_6 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            myattribut_6, setattr_1, "result", "name", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between myattribut_6 and setattr_1 in network masterNet"
if os_path_split_i____17 is not None and ReadTable_14 is not None:
    try:
        masterNet.connectNodes(
            os_path_split_i____17, ReadTable_14, "result", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between os_path_split_i____17 and ReadTable_14 in network masterNet"
if Get_parser_filename_13 is not None and os_path_split_i____17 is not None:
    try:
        masterNet.connectNodes(
            Get_parser_filename_13, os_path_split_i____17, "attrs", "in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Get_parser_filename_13 and os_path_split_i____17 in network masterNet"
masterNet.runOnNewData.value = True


def loadSavedStates_Pmv_Viewer_11(self=Pmv_Viewer_11, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|ind_docked
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|repair_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|selectInSphereGeoms
    ## Object root|ind_docked|selection
    ## Object root|ind_docked|lines
    ## Object root|ind_docked|AtomLabels
    ## Object root|ind_docked|ResidueLabels
    ## Object root|ind_docked|ChainLabels
    ## Object root|ind_docked|ProteinLabels
    ## Object root|ind_docked|sticks
    ## Object root|ind_docked|balls
    ## Object root|ind_docked|cpk
    ## Object root|ind_docked|CAsticks
    ## Object root|ind_docked|CAballs
    ## Object root|ind_docked|MSMS-MOL
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': True, 'visible': 1, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': True, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': 1, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': False, 'culling': 'back', 'name': 'MSMS-MOL', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|MSMS-MOL')
    if obj:
        apply(obj.Set, (), state)

    ## Material for MSMS-MOL
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for MSMS-MOL

    ## Clipping Planes for MSMS-MOL
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for MSMS-MOL

    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|repair_geoms|closeContactGeoms
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|ind_docked|lines|bonded
    ## Object root|ind_docked|lines|nobnds
    ## Object root|ind_docked|lines|bondorder
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLines
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLabels
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 24.21651176056633, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -32.095829], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 32.095829], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40.6337953575147, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 23.557865694994181, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [2.8689413, 6.2097216, -6.4630127], 'rotation': [-0.39943755, -0.13025042, 0.90746051, 0.0, 0.12423894, -0.98841476, -0.087183677, 0.0, 0.90830308, 0.077917494, 0.41099215, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-2.4972451, -6.9970546, 6.4630122], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_11.restoreStates_cb = Pmv_Viewer_11.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_11
Pmv_Viewer_11.menu.add_separator()
Pmv_Viewer_11.menu.add_command(label='Restore states', command=Pmv_Viewer_11.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

