########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:36:30 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/headandslice/headandslice_net.py,v 1.13 2007/10/08 20:20:32 vareille Exp $
#
# $Id: headandslice_net.py,v 1.13 2007/10/08 20:20:32 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_0 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_0,251,357)
    ##
    ## Saving State for Viewer
    Viewer_0.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 734, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 39.600000000000001, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 146, 'd1scale': 0.012999999999999999}
    apply(Viewer_0.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_0.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [31.499998092651367, 31.500001907348633, 31.500001907348633], 'rotation': [0.077318914234638214, -0.95897459983825684, -0.2727445662021637, 0.0, 0.88841801881790161, 0.19042238593101501, -0.4176754355430603, 0.0, 0.45247676968574524, -0.21001696586608887, 0.86669349670410156, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.25427311658859253, 0.25427311658859253, 0.25427311658859253], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-31.793123245239258, -31.435674667358398, -33.981407165527344], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_0.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_0.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_0.vi.rootObject:
        Viewer_0.vi.rootObject.clipP = []
        Viewer_0.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_0=None

try:
    ## saving node OrthoSliceZ ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSliceZ_1 = OrthoSlice(constrkw = {}, name='OrthoSliceZ', library=vollib)
    masterNet.addNode(OrthoSliceZ_1,1,153)
    apply(OrthoSliceZ_1.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63})
    OrthoSliceZ_1.inputPortByName['sliceNumber'].widget.set(29, run=False)
    OrthoSliceZ_1.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[0.17599999999999927, 0.0, 1.0, 1.0], [0.0, 0.093999999999999639, 1.0, 1.0], [0.0, 0.36999999999999988, 1.0, 1.0], [0.0, 0.64599999999999946, 1.0, 1.0], [0.0, 0.9159999999999997, 1.0, 1.0], [0.0, 1.0, 0.80800000000000127, 0.36599999999999999], [0.0, 1.0, 0.53200000000000036, 0.33700000000000002], [0.0, 1.0, 0.26199999999999979, 0.34300000000000003], [0.049999999999999822, 1.0, 0.0, 0.35999999999999999], [0.32000000000000006, 1.0, 0.0, 0.371], [0.59599999999999898, 1.0, 0.0, 0.38900000000000001], [0.87199999999999989, 1.0, 0.0, 1.0], [1.0, 0.85799999999999987, 0.0, 1.0], [1.0, 0.58200000000000007, 0.0, 1.0], [1.0, 0.30599999999999999, 0.0, 1.0], [1.0, 0.0, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSliceZ_1.inputPortByName['name'].widget.set("", run=False)
    apply(OrthoSliceZ_1.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSliceZ in network masterNet"
    print_exc()
    OrthoSliceZ_1=None

try:
    ## saving node OrthoSlicey ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSlicey_2 = OrthoSlice(constrkw = {}, name='OrthoSlicey', library=vollib)
    masterNet.addNode(OrthoSlicey_2,183,152)
    OrthoSlicey_2.inputPortByName['axis'].widget.set("y", run=False)
    apply(OrthoSlicey_2.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63})
    OrthoSlicey_2.inputPortByName['sliceNumber'].widget.set(20, run=False)
    OrthoSlicey_2.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.6666666865348817, 0.246], [0.0, 1.0, 0.40000003576278698, 0.26300000000000001], [0.0, 1.0, 0.13333338499069225, 0.26900000000000002], [0.13333326578140148, 1.0, 0.0, 0.28599999999999998], [0.3999999165534962, 1.0, 0.0, 0.29699999999999999], [0.66666662693023615, 1.0, 0.0, 0.29699999999999999], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSlicey_2.inputPortByName['name'].widget.set("", run=False)
    apply(OrthoSlicey_2.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSlicey in network masterNet"
    print_exc()
    OrthoSlicey_2=None

try:
    ## saving node Grid3DBB ##
    from Volume.VisionInterface.VolumeNodes import BoundingBox
    Grid3DBB_3 = BoundingBox(constrkw = {}, name='Grid3DBB', library=vollib)
    masterNet.addNode(Grid3DBB_3,455,37)
    Grid3DBB_3.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore BoundingBox named Grid3DBB in network masterNet"
    print_exc()
    Grid3DBB_3=None

try:
    ## saving node ReadAnyMap ##
    from Volume.VisionInterface.VolumeNodes import ReadAnyMap
    ReadAnyMap_4 = ReadAnyMap(constrkw = {}, name='ReadAnyMap', library=vollib)
    masterNet.addNode(ReadAnyMap_4,11,3)
    ReadAnyMap_4.inputPortByName['filename'].widget.set("ct_head.rawiv", run=False)
    apply(ReadAnyMap_4.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadAnyMap named ReadAnyMap in network masterNet"
    print_exc()
    ReadAnyMap_4=None

try:
    ## saving node OrthoSlice ##
    from Volume.VisionInterface.VolumeNodes import OrthoSlice
    OrthoSlice_5 = OrthoSlice(constrkw = {}, name='OrthoSlice', library=vollib)
    masterNet.addNode(OrthoSlice_5,361,152)
    OrthoSlice_5.inputPortByName['axis'].widget.set("x", run=False)
    apply(OrthoSlice_5.inputPortByName['sliceNumber'].widget.configure, (), {'max': 63})
    OrthoSlice_5.inputPortByName['sliceNumber'].widget.set(18, run=False)
    OrthoSlice_5.inputPortByName['colorMap'].widget.set({'mini': -7.5834474563598633, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.66666668653488159, 1.0], [0.0, 1.0, 0.40000003576278687, 1.0], [0.0, 1.0, 0.13333338499069214, 1.0], [0.13333326578140259, 1.0, 0.0, 1.0], [0.39999991655349731, 1.0, 0.0, 1.0], [0.66666662693023682, 1.0, 0.0, 1.0], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 2}, 'maxi': 253.0, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 2}, 'labelCfg': {'text': 'colorMap'}, 'class': 'NEColorMap'}, run=False)
    OrthoSlice_5.inputPortByName['name'].widget.set("", run=False)
    apply(OrthoSlice_5.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore OrthoSlice named OrthoSlice in network masterNet"
    print_exc()
    OrthoSlice_5=None

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_6 = Isocontour(constrkw = {}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_6,562,24)
    apply(UT_Isocontour_6.inputPortByName['isovalue'].widget.configure, (), {'max': 253.0, 'min': 0.0})
    UT_Isocontour_6.inputPortByName['isovalue'].widget.set(65.4823529412, run=False)
    UT_Isocontour_6.inputPortByName['calculatesignatures'].widget.set(1, run=False)
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_6=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_7 = IndexedPolygonsNE(constrkw = {}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_7,564,186)
    apply(indexedPolygons_7.inputPortByName['parent'].configure, (), {'parenting': 'current'})
    indexedPolygons_7.inputPortByName['name'].widget.set("", run=False)
    apply(indexedPolygons_7.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_7=None

masterNet.run()
masterNet.freeze()

## saving connections for network headandslice ##
if OrthoSliceZ_1 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSliceZ_1, Viewer_0, "OrthoSlice", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between OrthoSliceZ_1 and Viewer_0 in network masterNet"
if OrthoSlicey_2 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSlicey_2, Viewer_0, "OrthoSlice", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between OrthoSlicey_2 and Viewer_0 in network masterNet"
if Grid3DBB_3 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, Viewer_0, "Grid3DBB", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and Viewer_0 in network masterNet"
if ReadAnyMap_4 is not None and Grid3DBB_3 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, Grid3DBB_3, "grid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and Grid3DBB_3 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSlicey_2 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSlicey_2, "grid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSlicey_2 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSliceZ_1 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSliceZ_1, "grid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSliceZ_1 in network masterNet"
if ReadAnyMap_4 is not None and OrthoSlice_5 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, OrthoSlice_5, "grid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and OrthoSlice_5 in network masterNet"
if OrthoSlice_5 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            OrthoSlice_5, Viewer_0, "OrthoSlice", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between OrthoSlice_5 and Viewer_0 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if UT_Isocontour_6 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_6, indexedPolygons_7, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_6 and indexedPolygons_7 in network masterNet"
if ReadAnyMap_4 is not None and UT_Isocontour_6 is not None:
    try:
        masterNet.connectNodes(
            ReadAnyMap_4, UT_Isocontour_6, "grid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadAnyMap_4 and UT_Isocontour_6 in network masterNet"
if indexedPolygons_7 is not None and Viewer_0 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_7, Viewer_0, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indexedPolygons_7 and Viewer_0 in network masterNet"
if Grid3DBB_3 is not None and OrthoSlicey_2 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSlicey_2, "Grid3DBB", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSlicey_2 in network masterNet"
if Grid3DBB_3 is not None and OrthoSliceZ_1 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSliceZ_1, "Grid3DBB", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSliceZ_1 in network masterNet"
if Grid3DBB_3 is not None and OrthoSlice_5 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, OrthoSlice_5, "Grid3DBB", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and OrthoSlice_5 in network masterNet"
if Grid3DBB_3 is not None and indexedPolygons_7 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_3, indexedPolygons_7, "Grid3DBB", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_3 and indexedPolygons_7 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_0(self=Viewer_0, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|Grid3DBB
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'Grid3DBB', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Grid3DBB
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Grid3DBB

    ## Clipping Planes for Grid3DBB
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Grid3DBB

    ## Object root|Grid3DBB|OrthoSliceZ
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSliceZ', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSliceZ')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSliceZ
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSliceZ

    ## Clipping Planes for OrthoSliceZ
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSliceZ

    ## Object root|Grid3DBB|OrthoSlicey
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSlicey', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSlicey')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSlicey
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSlicey

    ## Clipping Planes for OrthoSlicey
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSlicey

    ## Object root|Grid3DBB|OrthoSlice
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 0, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'OrthoSlice', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|OrthoSlice')
    if obj:
        apply(obj.Set, (), state)

    ## Material for OrthoSlice
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for OrthoSlice

    ## Clipping Planes for OrthoSlice
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for OrthoSlice

    ## Object root|Grid3DBB|indexedPolygons
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'inherit', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'indexedPolygons', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|indexedPolygons')
    if obj:
        apply(obj.Set, (), state)

    ## Material for indexedPolygons
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 1.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for indexedPolygons

    ## Clipping Planes for indexedPolygons
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for indexedPolygons

    ## End Object root|Grid3DBB|indexedPolygons

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 39.600000000000001, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [31.499998092651367, 31.500001907348633, 31.500001907348633], 'rotation': [0.077318914234638214, -0.95897459983825684, -0.2727445662021637, 0.0, 0.88841801881790161, 0.19042238593101501, -0.4176754355430603, 0.0, 0.45247676968574524, -0.21001696586608887, 0.86669349670410156, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.25427311658859253, 0.25427311658859253, 0.25427311658859253], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-31.793123245239258, -31.435674667358398, -33.981407165527344], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_0.restoreStates_cb = Viewer_0.restoreStatesFirstRun = loadSavedStates_Viewer_0
Viewer_0.menu.add_separator()
Viewer_0.menu.add_command(label='Restore states', command=Viewer_0.restoreStates_cb)

#masterNet.run()
