/* CSHAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

/**
 * Action to display context-sensitive help for a component.
 */
public class CSHAction extends AbstractAction{
    
    private String id;
    
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.help.help");
    
    /**
     * creates a new CSHAction that opens the given id 
     */
    public CSHAction(String id) {
        super();
        this.id = id;
	putValue(Action.NAME, BUNDLE.getString("popup.whatis"));
    }

    public void actionPerformed(ActionEvent e) {
        HelpManager.showID(id);
    }
    
}
