/* GeneratorInstanceDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import javax.swing.JComponent;

import org.grinvin.generators.graphs.GraphGeneratorInstance;
import org.grinvin.generators.graphs.GraphListElementGeneratorSink;
import org.grinvin.worksheet.HasGraphList;

/**
 * Allows a generator list to be dropped onto a component.<p>
 * Currently only supports components of type
 * {@link org.grinvin.worksheet.HasGraphList}.
 */
public class GeneratorInstanceDropHandler extends AbstractDropHandler {
    
    // cannot be instantiated by clients
    private GeneratorInstanceDropHandler() {
        super(GraphGeneratorInstance.class, true);
    }
    
    /**
     * The unique shared object of this type.
     */
    private static final GeneratorInstanceDropHandler DROP_HANDLER = new GeneratorInstanceDropHandler();
    
    public static GeneratorInstanceDropHandler getInstance() {
        return DROP_HANDLER;
    }
    
    public boolean acceptDrop(JComponent target, Object object, int seqNr) {
        if (target instanceof HasGraphList) {
            new GraphListElementGeneratorSink(
                    (GraphGeneratorInstance)object, 
                    (HasGraphList)target).start();
            return true;
        } else
            return false;
    }
    
}
