/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MYSNAPTAB_H
#define MYSNAPTAB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qvariant.h>
#include <qwidget.h>
#include <kparts/part.h>

class QVBoxLayout;
class QHBoxLayout;
//class QGridLayout;
//class QSpacerItem;
class QTabWidget;
//class kxmameSnapLabel;
//class QTime;

#include "kxmamesnaplabel.h"

class MySnapTab : public QWidget
{
    Q_OBJECT

public:
    MySnapTab( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~MySnapTab();

    QTabWidget* screenshotTab;
    QWidget* snapTab;
    kxmameSnapLabel* snapPixmap;
    QWidget* flyerTab;
    kxmameSnapLabel* flyerPixmap;
    QWidget* cabTab;
    kxmameSnapLabel* cabPixmap;
    QWidget* marqueeTab;
    kxmameSnapLabel* marqueePixmap;
    QWidget* titleTab;
    kxmameSnapLabel* titlePixmap;
    QWidget* videoTab;
    kxmameSnapLabel* noVideoLabel;
    KParts::ReadOnlyPart *mVideoPreview;

    void stopVideo();
    void initVideo();
    void removeVideo();

protected:
    QHBoxLayout* MySnapTabLayout;
    QHBoxLayout* tabLayout;
    QHBoxLayout* tabLayout_2;
    QHBoxLayout* TabPageLayout;
    QHBoxLayout* TabPageLayout_2;
    QHBoxLayout* TabPageLayout_3;
    QVBoxLayout* TabPageLayout_4;
protected slots:
    virtual void languageChange();

};

#endif // MYSNAPTAB_H
