/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   ntt@physics.ucla.edu   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KXMAMESNAPTAB_H
#define KXMAMESNAPTAB_H

#include <qlabel.h>
#include <qpixmap.h>
#include <qtabwidget.h>
#include <klistview.h>

#include "screentab.h"
#include "kxmamesnaplabel.h"
#include "kxmame.h"
#include "gxmame.h"

class kxmameSnapTab : public MySnapTab
{
	Q_OBJECT
	public:
		kxmameSnapTab(KListView *gameList, QWidget* parent = 0,
			      const char* name = 0, WFlags fl = 0 );
		~kxmameSnapTab();
		
		void updateScreenTab();
		void setScaledScreenshot();
	
	protected slots:
		void screenTabChanged(QWidget *);
		
	protected:
		
		QPixmap get_pix(RomEntry *rom, screenshot_type sctype);
		void get_video(RomEntry *rom);
		int mVideoPreviewSlotStop;
		gchar *videoPreviewFileName;
		RomEntry *currentPreviewedRom;
		QPixmap kxmamelogo;
		kxmameSnapLabel * screenPixmap[5];
		KListView *mGameList;
};

#endif

