/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// This is essentially C++ -ized gtkjoy.c from gxmame.

#include <qsocketnotifier.h>
#include <klistview.h>
#include <qevent.h>
#include "kxmame.h"
#include "pref.h"
#include "kxmame_joy.h"
#include "common.h"
#include "gxmame.h"
#include "gui.h"

extern "C" {
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#ifdef ENABLE_JOYSTICK
# ifdef HAVE_LINUX_JOYSTICK_H
#   include <linux/joystick.h>
# else
#   error Joystick is only supported on Linux. Reconfigure with --disable-joystick.
#   undef ENABLE_JOYSTICK
# endif
#endif

}

#define AXIS_MAX	32767
#define AXIS_MIN	-32768

#define JOYUP		0
#define JOYDOWN		1
#define JOYLEFT 	2
#define JOYRIGHT	3

#define JOY_TIMEOUT	25

#ifdef ENABLE_JOYSTICK
static joyNotifier *mNotifier;
static void on_joystick_event (gint eventtype, gint button);
#endif
static void move_up(int);
static void move_down(int);
static void toggle_expand(void);
static QObject *focusPanel, *notfocusPanel;

const char *
get_joy_dev (void)
{
	static char *joy_dev_name[] = {
		"/dev/input/js0",
		"/dev/js0",
		"/dev/joy0",
		NULL
	};
	int i;

	for (i = 0; joy_dev_name[i]; i++) {
		if (g_file_test (joy_dev_name[i], G_FILE_TEST_EXISTS))
			break;
	}

	if (joy_dev_name[i])
		return joy_dev_name[i];
	else
		return joy_dev_name[0];
}

//#define JOY_TIMEOUT 30

bool joystick_focus;
Joystick *joydata;

joyNotifier::~joyNotifier ()
{
	if (mFd != 0)
		close(mFd);
	mFd = 0;
	
	if(mTimer) delete mTimer;
}

joyNotifier::joyNotifier( int socket, Type type, QObject * parent, const char * name )
	:QSocketNotifier (socket,type,parent,name )
{
	joyAxisDir = -1;
	
	mFd = socket;
	connect(this, SIGNAL(activated(int)), this, SLOT(joystick_io_func(int )));
	mTimer = new QTimer();
	connect(mTimer, SIGNAL(timeout()), this, SLOT(joyAxisRepeat()));
}

void joyNotifier::joystick_io_func (int socket)
{
#ifdef ENABLE_JOYSTICK
	struct js_event js;
	char buf[sizeof (struct js_event)];
	gsize readrc;

	if (!joydata) {
		GXMAME_DEBUG ("joystick_event: improper callback registration, %u", __LINE__);
		return;
	}

	readrc = read(socket, &buf, sizeof (struct js_event) );

	if (readrc != sizeof (struct js_event)) {
		GXMAME_DEBUG ("source, %d bytes read", readrc);
		return;
	}

	memcpy (&js, buf, sizeof (struct js_event));
	switch (js.type & ~JS_EVENT_INIT) {
	case JS_EVENT_BUTTON:
		if (js.number < joydata->num_buttons) 
			joydata->buttons[js.number] = js.value;
		break;
	case JS_EVENT_AXIS:
		if (js.number < joydata->num_axis) 
			joydata->axis[js.number] = js.value;
		break;
	}

	on_joystick_event (js.type, js.number);	
	return;
#endif	
}

void joyNotifier::joyAxisRepeat()
{
	if(!mTimer) return;
	
	switch(joyAxisDir) {
		case JOYUP:
			move_up(1);
			break;
		case JOYDOWN:
			move_down(1);
			break;
		case JOYLEFT:
			move_up(0);
			break;
		case JOYRIGHT:
			move_down(0);
			break;
		default:
			return;
	}
	
	mTimer->changeInterval(10*JOY_TIMEOUT);
	
}

Joystick *   
joystick_new (char * joystick)
{
#ifdef ENABLE_JOYSTICK
	//Joystick *joydata;
	int joystickfd;
	const char *devname;
	char name[128] = "Unknown";

	mNotifier = NULL;
	
	/* open joystick device */
	devname = (joystick) ? joystick : get_joy_dev ();
	
	joystickfd = open (devname, O_RDONLY);

	if (joystickfd < 0) {
		if ( errno == ENODEV ) {
			GXMAME_DEBUG ("Device not configured - did you load the module?");
		} else {
			GXMAME_DEBUG ("Couldn't open '%s'", devname);
			perror (devname);
		}
		return NULL;
	}
	
	joydata = (Joystick *) g_malloc (sizeof (Joystick));
	if (!joydata)
		return NULL;

	memset (joydata, 0, sizeof (Joystick));

	fcntl (joystickfd, F_SETFL, fcntl(joystickfd, F_GETFL) | O_ASYNC );
	ioctl (joystickfd, JSIOCGAXES, &joydata->num_axis);
	ioctl (joystickfd, JSIOCGBUTTONS, &joydata->num_buttons);
	ioctl (joystickfd, JSIOCGNAME (128), name);

	joydata->device_name = g_strdup (name);
	if (!joydata->device_name) {
		g_free (joydata);
		return NULL;
	}

	joydata->axis = (int *)g_malloc (joydata->num_axis * sizeof (int));
	if (!joydata->axis) {
		g_free (joydata->device_name);
		g_free (joydata);
		return NULL;
	}
	joydata->buttons = (int *)g_malloc (joydata->num_buttons * sizeof (int));
	if (!joydata->buttons) {
		g_free (joydata->device_name);
		g_free (joydata->axis);
		g_free (joydata);
		return NULL;
	}

	mNotifier = new joyNotifier(joystickfd, QSocketNotifier::Read, 0);
	
	return joydata;
#else
	return NULL;
#endif /* ENABLE_JOYSTICK */
}


void
joystick_close (Joystick * joydata)
{
#ifdef ENABLE_JOYSTICK
	if (!joydata) return;

	if (mNotifier) 
		delete mNotifier;
	mNotifier = NULL;
	
	g_free (joydata->device_name);
	g_free (joydata->axis);
	g_free (joydata->buttons);
	g_free (joydata);
	joydata = NULL;
#endif	
}

void setupJoyEventReceivers()
{
	if(globalIsMess) {
		focusPanel = (QObject *)(mainView->MessRomSelector()->dir->viewWidget());
		notfocusPanel = (QObject *)(mainView->GameListView());
	} else {
		focusPanel = (QObject *)(mainView->GameListView());
		notfocusPanel = (QObject *)(mainView->GameFilterList());
	}
	((QWidget*)focusPanel)->setFocus();
}

void
joy_focus_on (void)
{
	joystick_focus = TRUE;
}

void
joy_focus_off (void)
{
	joystick_focus = FALSE;
}

#ifdef ENABLE_JOYSTICK

static void switchReceiver() {
	if(((QWidget*)notfocusPanel)->isVisible() && ((QWidget *)focusPanel)->isVisible()) {
		QObject *tmp = notfocusPanel;
		notfocusPanel = focusPanel;
		focusPanel = tmp;
		//QFocusEvent me = QFocusEvent(QEvent::FocusIn);
		//QApplication::sendEvent(focusPanel,&me);
		((QWidget*)focusPanel)->setFocus();
	}
}

static void switchExec() {
	mainView->select_next_executable();
}

static void
on_joystick_event (gint eventtype, gint button)
{
	/*the focus is not set: another windows has been opened
	 or this is an init event */
	if (!joystick_focus || (eventtype & JS_EVENT_INIT))
		return;

	GXMAME_DEBUG ("joy: event=%i, button=%i", eventtype, button);
	
	if ((eventtype & JS_EVENT_BUTTON) && (button < joydata->num_buttons)) {
		GXMAME_DEBUG ("Joystick button %i %s", button, (joydata->buttons[button])?"pressed":"released");
		/* Button released*/
		if (joydata->buttons[button] == 0) {
			if(isInPrefDialog) {
				if(mainConfigDialog)
					mainConfigDialog->prefJoyButtonPressed(button);
				return;
			}
			if(button==gui_prefs.kxmameJoyButton[JOYSELECT]) {
				QKeyEvent me(QEvent::KeyPress,Qt::Key_Enter, 0, 0);
				QApplication::sendEvent(focusPanel, &me);
				me = QKeyEvent(QEvent::KeyRelease,Qt::Key_Enter, 0, 0);
				QApplication::sendEvent(focusPanel, &me);
			} else if (button == gui_prefs.kxmameJoyButton[JOYPARENT]) {
				if(globalIsMess && (focusPanel==
						(mainView->MessRomSelector()->dir->viewWidget()))) {
					mainView->MessRomSelector()->dir->cdUp();
				} else
					toggle_expand ();
			} else if (button == gui_prefs.kxmameJoyButton[JOYPANELSWITCH]) {
				switchReceiver();
			} else if (button == gui_prefs.kxmameJoyButton[JOYEXECSWITCH]) {
				switchExec();
			} else if (button == gui_prefs.kxmameJoyButton[JOYALT]) {
				if(globalIsMess && gui_prefs.allowAlternative && (focusPanel==
						(mainView->MessRomSelector()->dir->viewWidget())))
					mainView->playGameAlternative();
			}
		}
	} else if ((!isInPrefDialog) && (eventtype & JS_EVENT_AXIS) && (button < joydata->num_axis)) {
// 		if (repeat_source_id)
// 			g_source_remove (repeat_source_id);
		if(mNotifier && (mNotifier->mTimer)) {
			mNotifier->mTimer->stop();
			mNotifier->joyAxisDir = -1;
		}
		
		/* LEFT and RIGHT directions
		* (even Axis number)
		*/
		if (! (button & 1)) {
			if (joydata->axis[button] > (AXIS_MAX / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed right", button);
				move_down (0);
				mNotifier->joyAxisDir = JOYRIGHT;
				mNotifier->mTimer->start(10 * JOY_TIMEOUT, TRUE);
			} else if (joydata->axis[button] < (AXIS_MIN / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed left", button);
				move_up (0);
				mNotifier->joyAxisDir = JOYLEFT;
				mNotifier->mTimer->start(10*JOY_TIMEOUT, TRUE);
			}
		} else {
			/* UP and DOWN directions */
			if (joydata->axis[button] > (AXIS_MAX / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed down", button);
				move_down (1);
				mNotifier->joyAxisDir = JOYDOWN;
				mNotifier->mTimer->start(10*JOY_TIMEOUT, TRUE);
			} else if (joydata->axis[button] < (AXIS_MIN / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed up", button);
				move_up (1);
				mNotifier->joyAxisDir = JOYUP;
				mNotifier->mTimer->start(10*JOY_TIMEOUT, TRUE);
			}
		}
	}
}

#endif /* ENABLE_JOYSTICK */

static void move_up (int val)
{
	if(val == 1) {
		QKeyEvent me(QEvent::KeyPress,Qt::Key_Up, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
		me = QKeyEvent(QEvent::KeyRelease,Qt::Key_Up, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
	} else {
		QKeyEvent me(QEvent::KeyPress,Qt::Key_PageUp, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
		me = QKeyEvent(QEvent::KeyRelease,Qt::Key_PageUp, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
	}
}

static void move_down (int val)
{
	if(val == 1) {
		QKeyEvent me(QEvent::KeyPress,Qt::Key_Down, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
		me = QKeyEvent(QEvent::KeyRelease,Qt::Key_Down, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
	} else {
		QKeyEvent me(QEvent::KeyPress,Qt::Key_PageDown, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
		me = QKeyEvent(QEvent::KeyRelease,Qt::Key_PageDown, 0, 0);
		QApplication::sendEvent(focusPanel, &me);
	}
}

static void toggle_expand (void)
{
	QListViewItem *item = ((KListView *)focusPanel)->currentItem();
	
	if(item->childCount()) {
		item->setOpen(!item->isOpen());
	}
}

#include "kxmame_joy.moc"
