/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <qlayout.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>
 
#include "kfoldingconfigdata.h"
#include "kfoldingqueuedialog.h"
#include "kfoldingqueuewidget.h"

kfoldingQueueDialog::kfoldingQueueDialog( QWidget* parent, const char* name, const QString& caption, kfoldingConfigData* cfg )
 : KDialogBase( Plain, caption, Close, Close, parent, name ),
   _config( cfg )
{
	if ( !_config )
		return;
		
	setIcon( SmallIcon( "kfolding" ) );

	QFrame* frame = plainPage();
	QVBoxLayout* layout = new QVBoxLayout( frame );
	_queueWidget = new kfoldingQueueWidget( frame, "queue_widget", _config->workingDir() );
	layout->addWidget( _queueWidget );
	
//	connect( _queueWidget, SIGNAL( populated() ), this, SLOT( slotQueueWidgetPopulated() ) );
	resize( 800, 300 );
	return;
} // foldingQueueDialog ctor



kfoldingQueueDialog::~kfoldingQueueDialog()
{
	return;
} // kfoldingQueueDialog dtor



void kfoldingQueueDialog::slotClose()
{
	KDialogBase::slotClose();
	return;
} // slotClose


void kfoldingQueueDialog::slotQueueWidgetPopulated()
{
	return;
} // slotQueueWidgetPopulated

