/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *  
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGPROCESS_H
#define KFOLDINGPROCESS_H

#include <qobject.h>

#include "kfoldingprocessiface.h"

/**
@author Kevin Hessels
*/
class kfoldingConfigData;
class KAction;
class KActionCollection;
class KDirWatch;
class KProcess;

class kfoldingProcess : public QObject, virtual public kfoldingProcessIFace
{

Q_OBJECT

public:

	enum State
	{
		StateStopped 		= 0,	/** Folding@Home process is not running */
		StateRunning 		= 1,	/** Folding@Home process is running */
		StateSuspended 		= 2	/** Folding@Home process is suspended. NB!! current unused. */
	};

	enum Error
	{
		ErrorUnknown		= 0,
		ErrorNoExecutable 	= 1,	/** Executable not specified */
		ErrorBadExecutable 	= 2,	/** The file specified to setExecutable is not an executable file or permission denied */
		ErrorNotFoldingAtHome	= 3,	/** Not a Folding@home execuatble or unsupported version */
		ErrorMachineId		= 4,
		ErrorAlreadyRunning	= 5	/** A Folding@home process is already running in this directory */
	};

	kfoldingProcess( QObject* parent = 0L, const char* name = 0L, kfoldingConfigData* config = 0L );
	~kfoldingProcess();

	/**
	* Get the current state of the Folding@Home process
	*/
	kfoldingProcess::State processState();
	
	KAction* start() const { return _startAction; }
	KAction* stop() const { return _stopAction; }
	KAction* suspend() const { return _suspendAction; }
	KAction* resume() const { return _resumeAction; }
	
	void startFolding();
	void stopFolding();
	void restart();
	
	int currentProgress() const { return _currentProgress; }
	QString currentUnit() const { return _currentUnit; }
	
signals:
	/**
	* Emitted when Folding@Home process has changed its running state, either through
	* calling one of start(), stop(), suspend(), resume(), or when the process gets
	* terminated
	*/
	void stateChanged( kfoldingProcess::State );
	void progressUpdated();
	void processError( kfoldingProcess::Error );
	
private:
	void createActions();
	bool okayToRun();
	
	kfoldingConfigData* _cfg;

	KProcess*	_process;
	
	int		_currentProgress;
	QString		_currentUnit;
	
	bool		_doRestart;
	State		_processState;
	
	KAction*	_startAction;
	KAction*	_stopAction;
	KAction*	_suspendAction;
	KAction*	_resumeAction;
	KActionCollection* _actionCollection;
	
	KDirWatch*	_watcher;
    
private slots:
	void slotReadStdout( KProcess*, char*, int );
	void slotProcessExit( KProcess* );
	
	void slotStart();
	void slotStop();
	void slotSuspend();
	void slotResume();
	
	void slotUnitInfoUpdated( const QString& );
	void slotUnitInfoCreated( const QString& );
};

#endif
